/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignObjectWrapper;

class LazyClient
implements Client {
    private final BeanFactory beanFactory;
    private final Client delegate;
    private TraceFeignObjectWrapper wrapper;

    LazyClient(BeanFactory beanFactory, Client delegate) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        return ((Client)this.wrapper().wrap(this.delegate)).execute(request, options);
    }

    private TraceFeignObjectWrapper wrapper() {
        if (this.wrapper == null) {
            this.wrapper = new TraceFeignObjectWrapper(this.beanFactory);
        }
        return this.wrapper;
    }
}

