/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.LazyTracingFeignClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceLoadBalancerFeignClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TracingFeignClient;
import org.springframework.util.ClassUtils;

final class TraceFeignObjectWrapper {
    private static final Log log = LogFactory.getLog(TraceFeignObjectWrapper.class);
    private static final boolean ribbonPresent = ClassUtils.isPresent((String)"org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient", null) && ClassUtils.isPresent((String)"org.springframework.cloud.netflix.ribbon.SpringClientFactory", null);
    private final BeanFactory beanFactory;
    private CachingSpringLoadBalancerFactory cachingSpringLoadBalancerFactory;
    private Object springClientFactory;

    TraceFeignObjectWrapper(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    Object wrap(Object bean) {
        if (bean instanceof Client && !(bean instanceof TracingFeignClient)) {
            if (ribbonPresent && bean instanceof LoadBalancerFeignClient && !(bean instanceof TraceLoadBalancerFeignClient)) {
                if (AopUtils.getTargetClass((Object)bean).equals(LoadBalancerFeignClient.class)) {
                    LoadBalancerFeignClient client = (LoadBalancerFeignClient)bean;
                    return new TraceLoadBalancerFeignClient((Client)new TraceFeignObjectWrapper(this.beanFactory).wrap(client.getDelegate()), this.factory(), (SpringClientFactory)this.clientFactory(), this.beanFactory);
                }
                LoadBalancerFeignClient client = (LoadBalancerFeignClient)bean;
                try {
                    Field delegate = LoadBalancerFeignClient.class.getDeclaredField("delegate");
                    delegate.setAccessible(true);
                    delegate.set(client, new TraceFeignObjectWrapper(this.beanFactory).wrap(client.getDelegate()));
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    log.warn((Object)"Exception occurred while trying to access the delegate's field. Will fallback to default instrumentation mechanism, which means that the delegate might not be instrumented", (Throwable)e);
                }
                return new TraceLoadBalancerFeignClient((Client)client, this.factory(), (SpringClientFactory)this.clientFactory(), this.beanFactory);
            }
            if (ribbonPresent && bean instanceof TraceLoadBalancerFeignClient) {
                return bean;
            }
            return new LazyTracingFeignClient(this.beanFactory, (Client)bean);
        }
        return bean;
    }

    private CachingSpringLoadBalancerFactory factory() {
        if (this.cachingSpringLoadBalancerFactory == null) {
            this.cachingSpringLoadBalancerFactory = (CachingSpringLoadBalancerFactory)this.beanFactory.getBean(CachingSpringLoadBalancerFactory.class);
        }
        return this.cachingSpringLoadBalancerFactory;
    }

    private Object clientFactory() {
        if (this.springClientFactory == null) {
            this.springClientFactory = this.beanFactory.getBean(SpringClientFactory.class);
        }
        return this.springClientFactory;
    }
}

