/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth;

import java.lang.reflect.Method;
import org.springframework.cloud.sleuth.SpanName;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.core.annotation.AnnotationUtils;

public class DefaultSpanNamer
implements SpanNamer {
    private static boolean isDefaultToString(Object delegate, String spanName) {
        if (delegate instanceof Method) {
            return delegate.toString().equals(spanName);
        }
        return (delegate.getClass().getName() + "@" + Integer.toHexString(delegate.hashCode())).equals(spanName);
    }

    @Override
    public String name(Object object, String defaultValue) {
        String spanName;
        SpanName annotation = this.annotation(object);
        String string = spanName = annotation != null ? annotation.value() : object.toString();
        if (DefaultSpanNamer.isDefaultToString(object, spanName)) {
            return defaultValue;
        }
        return spanName;
    }

    private SpanName annotation(Object o) {
        if (o instanceof Method) {
            return (SpanName)AnnotationUtils.findAnnotation((Method)((Method)o), SpanName.class);
        }
        return (SpanName)AnnotationUtils.findAnnotation(o.getClass(), SpanName.class);
    }
}

