/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.redis;

import brave.Tracing;
import io.lettuce.core.resource.ClientResources;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.redis.TraceLettuceClientResourcesBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.redis.TraceRedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.redis.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={Tracing.class, ClientResources.class})
@AutoConfigureAfter(value={TraceAutoConfiguration.class})
@EnableConfigurationProperties(value={TraceRedisProperties.class})
public class TraceRedisAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    static class LettuceConfig {
        LettuceConfig() {
        }

        @Bean
        static TraceLettuceClientResourcesBeanPostProcessor traceLettuceClientResourcesBeanPostProcessor(Tracing tracing, TraceRedisProperties traceRedisProperties) {
            return new TraceLettuceClientResourcesBeanPostProcessor(tracing, traceRedisProperties);
        }
    }
}

