/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import brave.Span;
import brave.http.HttpTracing;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.sleuth.instrument.web.client.AbstractHttpHeadersFilter;
import org.springframework.cloud.sleuth.instrument.web.client.TraceCarrier;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;

final class TraceRequestHttpHeadersFilter
extends AbstractHttpHeadersFilter {
    private static final Log log = LogFactory.getLog(TraceRequestHttpHeadersFilter.class);

    private TraceRequestHttpHeadersFilter(HttpTracing httpTracing) {
        super(httpTracing);
    }

    static HttpHeadersFilter create(HttpTracing httpTracing) {
        return new TraceRequestHttpHeadersFilter(httpTracing);
    }

    public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will instrument the HTTP request headers [" + exchange.getRequest().getHeaders() + "]"));
        }
        TraceCarrier carrier = new TraceCarrier(exchange.getRequest(), input);
        Span currentSpan = this.currentSpan(carrier);
        Span span = this.injectedSpan(carrier, currentSpan);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Client span  " + span + " created for the request. New headers are " + carrier.filteredHeaders.toSingleValueMap()));
        }
        exchange.getAttributes().put(SPAN_ATTRIBUTE, span);
        HttpHeaders headersWithInput = new HttpHeaders();
        headersWithInput.addAll((MultiValueMap)input);
        this.addHeadersWithInput(carrier.filteredHeaders, headersWithInput);
        if (headersWithInput.containsKey((Object)"b3") || headersWithInput.containsKey((Object)"B3")) {
            headersWithInput.keySet().remove("b3");
            headersWithInput.keySet().remove("B3");
        }
        return headersWithInput;
    }

    private Span currentSpan(TraceCarrier carrier) {
        Span currentSpan = this.tracer.currentSpan();
        if (currentSpan != null) {
            return currentSpan;
        }
        TraceContextOrSamplingFlags contextOrFlags = this.extractor.extract((Object)carrier);
        return this.tracer.nextSpan(contextOrFlags);
    }

    private Span injectedSpan(TraceCarrier carrier, Span currentSpan) {
        if (currentSpan == null) {
            return this.handler.handleSend(this.injector, (Object)carrier);
        }
        Span clientSpan = this.tracer.nextSpan(TraceContextOrSamplingFlags.create((TraceContext)currentSpan.context()));
        return this.handler.handleSend(this.injector, (Object)carrier, clientSpan);
    }

    private void addHeadersWithInput(HttpHeaders filteredHeaders, HttpHeaders headersWithInput) {
        for (Map.Entry entry : filteredHeaders.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            headersWithInput.put(key, value);
        }
    }

    public boolean supports(HttpHeadersFilter.Type type) {
        return type.equals((Object)HttpHeadersFilter.Type.REQUEST);
    }
}

