/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.annotation;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.springframework.cloud.sleuth.annotation.AbstractSleuthMethodInvocationProcessor;
import org.springframework.cloud.sleuth.annotation.ContinueSpan;
import org.springframework.cloud.sleuth.annotation.NewSpan;
import org.springframework.cloud.sleuth.annotation.NonReactorSleuthMethodInvocationProcessor;
import org.springframework.util.StringUtils;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

class ReactorSleuthMethodInvocationProcessor
extends AbstractSleuthMethodInvocationProcessor {
    Tracing tracing;
    private NonReactorSleuthMethodInvocationProcessor nonReactorSleuthMethodInvocationProcessor;

    ReactorSleuthMethodInvocationProcessor() {
    }

    Tracing tracing() {
        if (this.tracing == null) {
            this.tracing = (Tracing)this.beanFactory.getBean(Tracing.class);
        }
        return this.tracing;
    }

    @Override
    public Object process(MethodInvocation invocation, NewSpan newSpan, ContinueSpan continueSpan) throws Throwable {
        Method method = invocation.getMethod();
        if (this.isReactorReturnType(method.getReturnType())) {
            return this.proceedUnderReactorSpan(invocation, newSpan, continueSpan);
        }
        return this.nonReactorSleuthMethodInvocationProcessor().process(invocation, newSpan, continueSpan);
    }

    private Object proceedUnderReactorSpan(MethodInvocation invocation, NewSpan newSpan, ContinueSpan continueSpan) throws Throwable {
        Span spanPrevious = this.tracer().currentSpan();
        Span span = newSpan != null || spanPrevious == null ? null : spanPrevious;
        String log = this.log(continueSpan);
        Publisher publisher = (Publisher)invocation.proceed();
        if (publisher instanceof Mono) {
            return new MonoSpan((Mono<Object>)((Mono)publisher), this, newSpan, span, invocation, log);
        }
        if (publisher instanceof Flux) {
            return new FluxSpan((Flux<Object>)((Flux)publisher), this, newSpan, span, invocation, log);
        }
        throw new IllegalArgumentException("Unexpected type of publisher: " + publisher.getClass());
    }

    private boolean isReactorReturnType(Class<?> returnType) {
        return Flux.class.equals(returnType) || Mono.class.equals(returnType);
    }

    private NonReactorSleuthMethodInvocationProcessor nonReactorSleuthMethodInvocationProcessor() {
        if (this.nonReactorSleuthMethodInvocationProcessor == null) {
            this.nonReactorSleuthMethodInvocationProcessor = new NonReactorSleuthMethodInvocationProcessor();
            this.nonReactorSleuthMethodInvocationProcessor.setBeanFactory(this.beanFactory);
        }
        return this.nonReactorSleuthMethodInvocationProcessor;
    }

    private static final class SpanSubscriber
    implements CoreSubscriber<Object>,
    Subscription,
    Scannable {
        final CoreSubscriber<? super Object> actual;
        final boolean isNewSpan;
        final Span span;
        final String log;
        final boolean hasLog;
        final CurrentTraceContext currentTraceContext;
        final ReactorSleuthMethodInvocationProcessor processor;
        final Context context;
        Subscription parent;

        SpanSubscriber(CoreSubscriber<? super Object> actual, ReactorSleuthMethodInvocationProcessor processor, MethodInvocation invocation, boolean isNewSpan, Span span, String log, boolean hasLog) {
            this.actual = actual;
            this.isNewSpan = isNewSpan;
            this.span = span;
            this.log = log;
            this.hasLog = hasLog;
            this.processor = processor;
            this.currentTraceContext = processor.tracing().currentTraceContext();
            this.context = actual.currentContext().put(TraceContext.class, (Object)span.context());
            processor.before(invocation, this.span, this.log, this.hasLog);
        }

        public void request(long n) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.span.context());){
                this.parent.request(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.span.context());){
                this.parent.cancel();
            }
            finally {
                this.processor.after(this.span, this.isNewSpan, this.log, this.hasLog);
            }
        }

        public Context currentContext() {
            return this.context;
        }

        public void onSubscribe(Subscription subscription) {
            this.parent = subscription;
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.span.context());){
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(Object o) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.span.context());){
                this.actual.onNext(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable error) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.span.context());){
                this.processor.onFailure(this.span, this.log, this.hasLog, error);
                this.actual.onError(error);
            }
            finally {
                this.processor.after(this.span, this.isNewSpan, this.log, this.hasLog);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.span.context());){
                this.actual.onComplete();
            }
            finally {
                this.processor.after(this.span, this.isNewSpan, this.log, this.hasLog);
            }
        }

        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.ACTUAL) {
                return this.actual;
            }
            if (key == Scannable.Attr.PARENT) {
                return this.parent;
            }
            return null;
        }
    }

    private static final class MonoSpan
    extends MonoOperator<Object, Object> {
        final Span span;
        final MethodInvocation invocation;
        final String log;
        final boolean hasLog;
        final ReactorSleuthMethodInvocationProcessor processor;
        final NewSpan newSpan;

        MonoSpan(Mono<Object> source, ReactorSleuthMethodInvocationProcessor processor, NewSpan newSpan, @Nullable Span span, MethodInvocation invocation, String log) {
            super(source);
            this.processor = processor;
            this.newSpan = newSpan;
            this.span = span;
            this.invocation = invocation;
            this.log = log;
            this.hasLog = StringUtils.hasText((String)log);
        }

        public void subscribe(CoreSubscriber<? super Object> actual) {
            Span span;
            Tracer tracer = this.processor.tracer();
            if (this.span == null) {
                span = tracer.nextSpan();
                this.processor.newSpanParser().parse(this.invocation, this.newSpan, (SpanCustomizer)span);
                span.start();
            } else {
                span = this.span;
            }
            try (CurrentTraceContext.Scope ws = this.processor.currentTraceContext().maybeScope(span.context());){
                this.source.subscribe((CoreSubscriber)new SpanSubscriber(actual, this.processor, this.invocation, this.span == null, span, this.log, this.hasLog));
            }
        }
    }

    private static final class FluxSpan
    extends FluxOperator<Object, Object> {
        final Span span;
        final MethodInvocation invocation;
        final String log;
        final boolean hasLog;
        final ReactorSleuthMethodInvocationProcessor processor;
        final NewSpan newSpan;

        FluxSpan(Flux<Object> source, ReactorSleuthMethodInvocationProcessor processor, NewSpan newSpan, @Nullable Span span, MethodInvocation invocation, String log) {
            super(source);
            this.span = span;
            this.newSpan = newSpan;
            this.invocation = invocation;
            this.log = log;
            this.hasLog = StringUtils.hasText((String)log);
            this.processor = processor;
        }

        public void subscribe(CoreSubscriber<? super Object> actual) {
            Span span;
            Tracer tracer = this.processor.tracer();
            if (this.span == null) {
                span = tracer.newTrace();
                this.processor.newSpanParser().parse(this.invocation, this.newSpan, (SpanCustomizer)span);
                span.start();
            } else {
                span = this.span;
            }
            try (CurrentTraceContext.Scope ws = this.processor.currentTraceContext().maybeScope(span.context());){
                this.source.subscribe((CoreSubscriber)new SpanSubscriber(actual, this.processor, this.invocation, this.span == null, span, this.log, this.hasLog));
            }
        }
    }
}

