/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import brave.Tracer;
import brave.Tracing;
import brave.jms.JmsTracing;
import brave.kafka.clients.KafkaTracing;
import brave.messaging.MessagingRequest;
import brave.messaging.MessagingTracing;
import brave.messaging.MessagingTracingCustomizer;
import brave.propagation.Propagation;
import brave.sampler.SamplerFunction;
import brave.spring.rabbit.SpringRabbitTracing;
import java.util.ArrayList;
import java.util.List;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.aws.messaging.config.QueueMessageHandlerFactory;
import org.springframework.cloud.aws.messaging.listener.QueueMessageHandler;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.messaging.ConsumerSampler;
import org.springframework.cloud.sleuth.instrument.messaging.OnMessagingEnabled;
import org.springframework.cloud.sleuth.instrument.messaging.ProducerSampler;
import org.springframework.cloud.sleuth.instrument.messaging.SleuthKafkaAspect;
import org.springframework.cloud.sleuth.instrument.messaging.SleuthMessagingProperties;
import org.springframework.cloud.sleuth.instrument.messaging.SleuthRabbitBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.messaging.SqsQueueMessageHandlerFactory;
import org.springframework.cloud.sleuth.instrument.messaging.TraceSpringMessagingAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.messaging.TracingConnectionFactoryBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.messaging.TracingJmsBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.messaging.TracingMethodMessageHandlerAdapter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.jms.annotation.JmsListenerConfigurer;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.lang.Nullable;
import org.springframework.messaging.support.MessageHeaderAccessor;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={Tracing.class})
@AutoConfigureAfter(value={TraceAutoConfiguration.class, TraceSpringMessagingAutoConfiguration.class})
@OnMessagingEnabled
@EnableConfigurationProperties(value={SleuthMessagingProperties.class})
public class TraceMessagingAutoConfiguration {
    @Autowired(required=false)
    List<MessagingTracingCustomizer> messagingTracingCustomizers = new ArrayList<MessagingTracingCustomizer>();

    @Bean
    @ConditionalOnMissingBean
    MessagingTracing messagingTracing(Tracing tracing, @Nullable @ProducerSampler SamplerFunction<MessagingRequest> producerSampler, @Nullable @ConsumerSampler SamplerFunction<MessagingRequest> consumerSampler) {
        MessagingTracing.Builder builder = MessagingTracing.newBuilder((Tracing)tracing);
        if (producerSampler != null) {
            builder.producerSampler(producerSampler);
        }
        if (consumerSampler != null) {
            builder.consumerSampler(consumerSampler);
        }
        for (MessagingTracingCustomizer customizer : this.messagingTracingCustomizers) {
            customizer.customize(builder);
        }
        return builder.build();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.sleuth.messaging.sqs.enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={QueueMessageHandler.class})
    protected static class SleuthSqsConfiguration {
        protected SleuthSqsConfiguration() {
        }

        @Bean
        TracingMethodMessageHandlerAdapter tracingMethodMessageHandlerAdapter(MessagingTracing messagingTracing, Propagation.Getter<MessageHeaderAccessor, String> traceMessagePropagationGetter) {
            return new TracingMethodMessageHandlerAdapter(messagingTracing, traceMessagePropagationGetter);
        }

        @Bean
        QueueMessageHandlerFactory sqsQueueMessageHandlerFactory(TracingMethodMessageHandlerAdapter tracingMethodMessageHandlerAdapter) {
            return new SqsQueueMessageHandlerFactory(tracingMethodMessageHandlerAdapter);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.sleuth.messaging.jms.enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={JmsListenerConfigurer.class})
    @ConditionalOnBean(value={JmsListenerEndpointRegistry.class})
    @Role(value=2)
    protected static class SleuthJmsConfiguration {
        protected SleuthJmsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        JmsTracing jmsTracing(MessagingTracing messagingTracing, SleuthMessagingProperties properties) {
            return JmsTracing.newBuilder((MessagingTracing)messagingTracing).remoteServiceName(properties.getMessaging().getJms().getRemoteServiceName()).build();
        }

        @Bean
        @ConditionalOnMissingBean
        TracingConnectionFactoryBeanPostProcessor tracingConnectionFactoryBeanPostProcessor(BeanFactory beanFactory) {
            return new TracingConnectionFactoryBeanPostProcessor(beanFactory);
        }

        @Bean
        JmsListenerConfigurer configureTracing(BeanFactory beanFactory, JmsListenerEndpointRegistry defaultRegistry) {
            return registrar -> {
                TracingJmsBeanPostProcessor processor = this.tracingJmsBeanPostProcessor(beanFactory);
                JmsListenerEndpointRegistry registry = registrar.getEndpointRegistry();
                registrar.setEndpointRegistry((JmsListenerEndpointRegistry)processor.wrap(registry == null ? defaultRegistry : registry));
            };
        }

        @Bean
        TracingJmsBeanPostProcessor tracingJmsBeanPostProcessor(BeanFactory beanFactory) {
            return new TracingJmsBeanPostProcessor(beanFactory);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.sleuth.messaging.kafka.enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={ProducerFactory.class})
    protected static class SleuthKafkaConfiguration {
        protected SleuthKafkaConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        KafkaTracing kafkaTracing(MessagingTracing messagingTracing, SleuthMessagingProperties properties) {
            return KafkaTracing.newBuilder((MessagingTracing)messagingTracing).remoteServiceName(properties.getMessaging().getKafka().getRemoteServiceName()).build();
        }

        @Bean
        @ConditionalOnMissingBean
        SleuthKafkaAspect sleuthKafkaAspect(KafkaTracing kafkaTracing, Tracer tracer) {
            return new SleuthKafkaAspect(kafkaTracing, tracer);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.sleuth.messaging.rabbit.enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={RabbitTemplate.class})
    protected static class SleuthRabbitConfiguration {
        protected SleuthRabbitConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        static SleuthRabbitBeanPostProcessor sleuthRabbitBeanPostProcessor(BeanFactory beanFactory) {
            return new SleuthRabbitBeanPostProcessor(beanFactory);
        }

        @Bean
        @ConditionalOnMissingBean
        SpringRabbitTracing springRabbitTracing(MessagingTracing messagingTracing, SleuthMessagingProperties properties) {
            return SpringRabbitTracing.newBuilder((MessagingTracing)messagingTracing).remoteServiceName(properties.getMessaging().getRabbit().getRemoteServiceName()).build();
        }
    }
}

