/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.cloud.sleuth.instrument.async.TraceableScheduledExecutorService;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.cloud.sleuth.instrument.reactor.TraceReactorAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import reactor.core.publisher.Hooks;
import reactor.core.scheduler.Schedulers;

class HookRegisteringBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    private static final Log log = LogFactory.getLog(HookRegisteringBeanDefinitionRegistryPostProcessor.class);
    final ConfigurableApplicationContext springContext;

    HookRegisteringBeanDefinitionRegistryPostProcessor(ConfigurableApplicationContext springContext) {
        this.springContext = springContext;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) {
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        HookRegisteringBeanDefinitionRegistryPostProcessor.setupHooks(this.springContext);
    }

    static void setupHooks(ConfigurableApplicationContext springContext) {
        ConfigurableEnvironment environment = springContext.getEnvironment();
        boolean decorateOnEach = (Boolean)environment.getProperty("spring.sleuth.reactor.decorate-on-each", Boolean.class, (Object)true);
        if (decorateOnEach) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Decorating onEach operator instrumentation");
            }
            Hooks.onEachOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY, ReactorSleuth.scopePassingSpanOperator(springContext));
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Decorating onLast operator instrumentation");
            }
            Hooks.onLastOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY, ReactorSleuth.scopePassingSpanOperator(springContext));
        }
        Schedulers.setExecutorServiceDecorator((String)"sleuth", (scheduler, scheduledExecutorService) -> new TraceableScheduledExecutorService((BeanFactory)springContext, (ExecutorService)scheduledExecutorService));
    }
}

