/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.SpanCustomizer;
import brave.http.HttpResponse;
import brave.http.HttpResponseParser;
import brave.propagation.TraceContext;
import org.springframework.cloud.sleuth.instrument.web.SleuthHttpClientParser;
import org.springframework.cloud.sleuth.instrument.web.TraceKeys;

class SleuthHttpServerParser
extends SleuthHttpClientParser
implements HttpResponseParser {
    private static final String STATUS_CODE_KEY = "http.status_code";

    SleuthHttpServerParser(TraceKeys traceKeys) {
        super(traceKeys);
    }

    public void parse(HttpResponse response, TraceContext context, SpanCustomizer span) {
        int httpStatus = response.statusCode();
        if (httpStatus == 0) {
            return;
        }
        if (httpStatus == 200 && response.error() == null) {
            span.tag(STATUS_CODE_KEY, String.valueOf(500));
        } else if (httpStatus >= 100 && httpStatus < 200 || httpStatus > 399) {
            span.tag(STATUS_CODE_KEY, String.valueOf(httpStatus));
        }
    }
}

