/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.Span;
import brave.Tracer;
import brave.http.HttpServerHandler;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import brave.propagation.TraceContext;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Subscription;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.web.SleuthWebProperties;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

public final class TraceWebFilter
implements WebFilter,
Ordered {
    public static final int ORDER = -2147483643;
    protected static final String TRACE_REQUEST_ATTR = TraceWebFilter.class.getName() + ".TRACE";
    static final String MVC_CONTROLLER_CLASS_KEY = "mvc.controller.class";
    static final String MVC_CONTROLLER_METHOD_KEY = "mvc.controller.method";
    private static final Log log = LogFactory.getLog(TraceWebFilter.class);
    private static final String STATUS_CODE_KEY = "http.status_code";
    private static final String TRACE_SPAN_WITHOUT_PARENT = TraceWebFilter.class.getName() + ".SPAN_WITH_NO_PARENT";
    private final BeanFactory beanFactory;
    Tracer tracer;
    HttpServerHandler<HttpServerRequest, HttpServerResponse> handler;
    SleuthWebProperties webProperties;

    TraceWebFilter(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public static WebFilter create(BeanFactory beanFactory) {
        return new TraceWebFilter(beanFactory);
    }

    HttpServerHandler<HttpServerRequest, HttpServerResponse> handler() {
        if (this.handler == null) {
            this.handler = HttpServerHandler.create((HttpTracing)((HttpTracing)this.beanFactory.getBean(HttpTracing.class)));
        }
        return this.handler;
    }

    Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = ((HttpTracing)this.beanFactory.getBean(HttpTracing.class)).tracing().tracer();
        }
        return this.tracer;
    }

    SleuthWebProperties sleuthWebProperties() {
        if (this.webProperties == null) {
            this.webProperties = (SleuthWebProperties)this.beanFactory.getBean(SleuthWebProperties.class);
        }
        return this.webProperties;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        boolean tracePresent;
        String uri = exchange.getRequest().getPath().pathWithinApplication().value();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received a request to uri [" + uri + "]"));
        }
        Mono source = chain.filter(exchange);
        boolean bl = tracePresent = this.tracer().currentSpan() != null;
        if (tracePresent) {
            this.tracer().withSpanInScope(null);
        }
        return new MonoWebFilterTrace((Mono<? extends Void>)source, exchange, tracePresent, this);
    }

    public int getOrder() {
        return this.sleuthWebProperties().getFilterOrder();
    }

    static final class WrappedResponse
    extends HttpServerResponse {
        final ServerHttpResponse delegate;
        final String method;
        final String httpRoute;

        WrappedResponse(ServerHttpResponse resp, String method, String httpRoute) {
            this.delegate = resp;
            this.method = method;
            this.httpRoute = httpRoute;
        }

        public String method() {
            return this.method;
        }

        public String route() {
            return this.httpRoute;
        }

        public ServerHttpResponse unwrap() {
            return this.delegate;
        }

        public int statusCode() {
            return this.delegate.getStatusCode() != null ? this.delegate.getStatusCode().value() : 0;
        }
    }

    static final class WrappedRequest
    extends HttpServerRequest {
        final ServerHttpRequest delegate;

        WrappedRequest(ServerHttpRequest delegate) {
            this.delegate = delegate;
        }

        public ServerHttpRequest unwrap() {
            return this.delegate;
        }

        public boolean parseClientIpAndPort(Span span) {
            InetSocketAddress addr = this.delegate.getRemoteAddress();
            if (addr == null) {
                return false;
            }
            return span.remoteIpAndPort(addr.getAddress().getHostAddress(), addr.getPort());
        }

        public String method() {
            return this.delegate.getMethodValue();
        }

        public String path() {
            return this.delegate.getPath().toString();
        }

        public String url() {
            return this.delegate.getURI().toString();
        }

        public String header(String name) {
            return this.delegate.getHeaders().getFirst(name);
        }
    }

    private static class MonoWebFilterTrace
    extends MonoOperator<Void, Void> {
        final ServerWebExchange exchange;
        final Tracer tracer;
        final Span attrSpan;
        final HttpServerHandler<HttpServerRequest, HttpServerResponse> handler;
        final AtomicBoolean initialSpanAlreadyRemoved = new AtomicBoolean();
        final boolean initialTracePresent;

        MonoWebFilterTrace(Mono<? extends Void> source, ServerWebExchange exchange, boolean initialTracePresent, TraceWebFilter parent) {
            super(source);
            this.tracer = parent.tracer();
            this.handler = parent.handler();
            this.exchange = exchange;
            this.attrSpan = (Span)exchange.getAttribute(TRACE_REQUEST_ATTR);
            this.initialTracePresent = initialTracePresent;
        }

        public void subscribe(CoreSubscriber<? super Void> subscriber) {
            Context context = this.contextWithoutInitialSpan(subscriber.currentContext());
            this.source.subscribe((CoreSubscriber)new WebFilterTraceSubscriber(subscriber, context, this.findOrCreateSpan(context), this));
        }

        private Context contextWithoutInitialSpan(Context context) {
            if (this.initialTracePresent && !this.initialSpanAlreadyRemoved.get()) {
                context = context.delete(TraceContext.class);
                this.initialSpanAlreadyRemoved.set(true);
            }
            return context;
        }

        private Span findOrCreateSpan(Context c) {
            Span span;
            if (c.hasKey(TraceContext.class)) {
                TraceContext parent = (TraceContext)c.get(TraceContext.class);
                span = this.tracer.newChild(parent).start();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found span in reactor context" + span));
                }
            } else {
                if (this.attrSpan != null) {
                    span = this.attrSpan;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found span in attribute " + span));
                    }
                } else {
                    span = this.handler.handleReceive((HttpServerRequest)new WrappedRequest(this.exchange.getRequest()));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Handled receive of span " + span));
                    }
                }
                this.exchange.getAttributes().put(TRACE_REQUEST_ATTR, span);
            }
            return span;
        }

        static final class WebFilterTraceSubscriber
        implements CoreSubscriber<Void> {
            final CoreSubscriber<? super Void> actual;
            final Context context;
            final Span span;
            final ServerWebExchange exchange;
            final HttpServerHandler<HttpServerRequest, HttpServerResponse> handler;

            WebFilterTraceSubscriber(CoreSubscriber<? super Void> actual, Context context, Span span, MonoWebFilterTrace parent) {
                this.actual = actual;
                this.span = span;
                this.context = context.put(TraceContext.class, (Object)span.context());
                this.exchange = parent.exchange;
                this.handler = parent.handler;
            }

            public void onSubscribe(Subscription subscription) {
                this.actual.onSubscribe(subscription);
            }

            public void onNext(Void aVoid) {
            }

            public void onError(Throwable t) {
                this.terminateSpan(t);
                this.actual.onError(t);
            }

            public void onComplete() {
                this.terminateSpan(null);
                this.actual.onComplete();
            }

            public Context currentContext() {
                return this.context;
            }

            private void terminateSpan(@Nullable Throwable t) {
                Object attribute = this.exchange.getAttribute(HandlerMapping.BEST_MATCHING_HANDLER_ATTRIBUTE);
                this.addClassMethodTag(attribute, this.span);
                this.addClassNameTag(attribute, this.span);
                Object pattern = this.exchange.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
                String httpRoute = pattern != null ? pattern.toString() : "";
                this.addResponseTagsForSpanWithoutParent(this.exchange, this.exchange.getResponse(), this.span);
                WrappedResponse response = new WrappedResponse(this.exchange.getResponse(), this.exchange.getRequest().getMethodValue(), httpRoute);
                this.handler.handleSend((Object)response, t, this.span);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Handled send of " + this.span));
                }
            }

            private void addClassMethodTag(Object handler, Span span) {
                if (handler instanceof HandlerMethod) {
                    String methodName = ((HandlerMethod)handler).getMethod().getName();
                    span.tag(TraceWebFilter.MVC_CONTROLLER_METHOD_KEY, methodName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding a method tag with value [" + methodName + "] to a span " + span));
                    }
                }
            }

            private void addClassNameTag(Object handler, Span span) {
                if (handler == null) {
                    return;
                }
                String className = handler instanceof HandlerMethod ? ((HandlerMethod)handler).getBeanType().getSimpleName() : handler.getClass().getSimpleName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding a class tag with value [" + className + "] to a span " + span));
                }
                span.tag(TraceWebFilter.MVC_CONTROLLER_CLASS_KEY, className);
            }

            private void addResponseTagsForSpanWithoutParent(ServerWebExchange exchange, ServerHttpResponse response, Span span) {
                if (this.spanWithoutParent(exchange) && response.getStatusCode() != null && span != null) {
                    span.tag(TraceWebFilter.STATUS_CODE_KEY, String.valueOf(response.getStatusCode().value()));
                }
            }

            private boolean spanWithoutParent(ServerWebExchange exchange) {
                return exchange.getAttribute(TRACE_SPAN_WITHOUT_PARENT) != null;
            }
        }
    }
}

