/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import brave.Span;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.netty.bootstrap.Bootstrap;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.internal.LazyBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClient;
import reactor.util.context.Context;

class HttpClientBeanPostProcessor
implements BeanPostProcessor {
    final ConfigurableApplicationContext springContext;

    HttpClientBeanPostProcessor(ConfigurableApplicationContext springContext) {
        this.springContext = springContext;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        LazyBean<HttpTracing> httpTracing = LazyBean.create(this.springContext, HttpTracing.class);
        if (bean instanceof HttpClient) {
            return ((HttpClient)bean).doOnResponseError((BiConsumer)new TracingDoOnErrorResponse(httpTracing)).doOnResponse((BiConsumer)new TracingDoOnResponse(httpTracing)).doOnRequestError((BiConsumer)new TracingDoOnErrorRequest(httpTracing)).doOnRequest((BiConsumer)new TracingDoOnRequest(httpTracing)).mapConnect((BiFunction)new TracingMapConnect(httpTracing));
        }
        return bean;
    }

    static final class HttpClientResponseWrapper
    extends HttpClientResponse {
        final reactor.netty.http.client.HttpClientResponse delegate;

        HttpClientResponseWrapper(reactor.netty.http.client.HttpClientResponse delegate) {
            this.delegate = delegate;
        }

        public String method() {
            return this.delegate.method().name();
        }

        public Object unwrap() {
            return this.delegate;
        }

        public int statusCode() {
            return this.delegate.status().code();
        }
    }

    static final class HttpClientRequestWrapper
    extends HttpClientRequest {
        final reactor.netty.http.client.HttpClientRequest delegate;

        HttpClientRequestWrapper(reactor.netty.http.client.HttpClientRequest delegate) {
            this.delegate = delegate;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.method().name();
        }

        public String path() {
            return "/" + this.delegate.path();
        }

        public String url() {
            return this.delegate.resourceUrl();
        }

        public String header(String name) {
            return this.delegate.requestHeaders().get(name);
        }

        public void header(String name, String value) {
            this.delegate.header((CharSequence)name, (CharSequence)value);
        }
    }

    private static abstract class AbstractTracingDoOnHandler {
        final LazyBean<HttpTracing> httpTracing;
        HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;

        AbstractTracingDoOnHandler(LazyBean<HttpTracing> httpTracing) {
            this.httpTracing = httpTracing;
        }

        HttpClientHandler<HttpClientRequest, HttpClientResponse> handler() {
            if (this.handler == null) {
                this.handler = HttpClientHandler.create((HttpTracing)this.httpTracing.get());
            }
            return this.handler;
        }

        void handle(Context context, @Nullable reactor.netty.http.client.HttpClientResponse resp, @Nullable Throwable error) {
            CurrentClientSpan ref = (CurrentClientSpan)context.getOrDefault(CurrentClientSpan.class, null);
            if (ref == null) {
                return;
            }
            Span clientSpan = ref.getAndSet(null);
            if (clientSpan == null) {
                return;
            }
            HttpClientResponseWrapper response = resp != null ? new HttpClientResponseWrapper(resp) : null;
            this.handler().handleReceive((Object)response, error, clientSpan);
        }
    }

    private static class TracingDoOnErrorResponse
    extends AbstractTracingDoOnHandler
    implements BiConsumer<reactor.netty.http.client.HttpClientResponse, Throwable> {
        TracingDoOnErrorResponse(LazyBean<HttpTracing> httpTracing) {
            super(httpTracing);
        }

        @Override
        public void accept(reactor.netty.http.client.HttpClientResponse response, Throwable error) {
            this.handle(response.currentContext(), response, error);
        }
    }

    private static class TracingDoOnErrorRequest
    extends AbstractTracingDoOnHandler
    implements BiConsumer<reactor.netty.http.client.HttpClientRequest, Throwable> {
        TracingDoOnErrorRequest(LazyBean<HttpTracing> httpTracing) {
            super(httpTracing);
        }

        @Override
        public void accept(reactor.netty.http.client.HttpClientRequest req, Throwable error) {
            this.handle(req.currentContext(), null, error);
        }
    }

    private static class TracingDoOnResponse
    extends AbstractTracingDoOnHandler
    implements BiConsumer<reactor.netty.http.client.HttpClientResponse, Connection> {
        TracingDoOnResponse(LazyBean<HttpTracing> httpTracing) {
            super(httpTracing);
        }

        @Override
        public void accept(reactor.netty.http.client.HttpClientResponse response, Connection connection) {
            this.handle(response.currentContext(), response, null);
        }
    }

    private static class TracingDoOnRequest
    implements BiConsumer<reactor.netty.http.client.HttpClientRequest, Connection> {
        final LazyBean<HttpTracing> httpTracing;
        HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;

        TracingDoOnRequest(LazyBean<HttpTracing> httpTracing) {
            this.httpTracing = httpTracing;
        }

        HttpClientHandler<HttpClientRequest, HttpClientResponse> handler() {
            if (this.handler == null) {
                this.handler = HttpClientHandler.create((HttpTracing)this.httpTracing.get());
            }
            return this.handler;
        }

        CurrentTraceContext currentTraceContext() {
            return this.httpTracing.get().tracing().currentTraceContext();
        }

        @Override
        public void accept(reactor.netty.http.client.HttpClientRequest req, Connection connection) {
            CurrentClientSpan ref = (CurrentClientSpan)req.currentContext().getOrDefault(CurrentClientSpan.class, null);
            if (ref == null) {
                return;
            }
            Span clientSpan = ref.getAndSet(null);
            if (clientSpan != null) {
                clientSpan.abandon();
            }
            TraceContext parent = (TraceContext)req.currentContext().getOrDefault(TraceContext.class, null);
            HttpClientRequestWrapper request = new HttpClientRequestWrapper(req);
            clientSpan = this.handler().handleSendWithParent((HttpClientRequest)request, parent);
            TracingDoOnRequest.parseConnectionAddress(connection, clientSpan);
            ref.set(clientSpan);
        }

        static void parseConnectionAddress(Connection connection, Span span) {
            if (span.isNoop()) {
                return;
            }
            InetSocketAddress socketAddress = connection.address();
            span.remoteIpAndPort(socketAddress.getHostString(), socketAddress.getPort());
        }
    }

    private static class TracingMapConnect
    implements BiFunction<Mono<? extends Connection>, Bootstrap, Mono<? extends Connection>> {
        final LazyBean<HttpTracing> httpTracing;
        CurrentTraceContext currentTraceContext;

        TracingMapConnect(LazyBean<HttpTracing> httpTracing) {
            this.httpTracing = httpTracing;
        }

        @Override
        public Mono<? extends Connection> apply(Mono<? extends Connection> mono, Bootstrap bootstrap) {
            return mono.subscriberContext(context -> {
                TraceContext invocationContext = this.currentTraceContext().get();
                if (invocationContext != null) {
                    context = context.put(TraceContext.class, (Object)invocationContext);
                }
                return context.put(CurrentClientSpan.class, (Object)new CurrentClientSpan());
            });
        }

        CurrentTraceContext currentTraceContext() {
            if (this.currentTraceContext == null) {
                this.currentTraceContext = this.httpTracing.get().tracing().currentTraceContext();
            }
            return this.currentTraceContext;
        }
    }

    private static final class CurrentClientSpan
    extends AtomicReference<Span> {
        private CurrentClientSpan() {
        }
    }
}

