/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import brave.http.HttpTracing;
import brave.httpasyncclient.TracingHttpAsyncClientBuilder;
import brave.httpclient.TracingHttpClientBuilder;
import brave.spring.web.TracingClientHttpRequestInterceptor;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoRestTemplateCustomizer;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.cloud.commons.httpclient.HttpClientConfiguration;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.sleuth.instrument.web.TraceWebServletAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.client.HttpClientBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.client.LazyTracingClientHttpRequestInterceptor;
import org.springframework.cloud.sleuth.instrument.web.client.SleuthWebClientEnabled;
import org.springframework.cloud.sleuth.instrument.web.client.TraceRequestHttpHeadersFilter;
import org.springframework.cloud.sleuth.instrument.web.client.TraceResponseHttpHeadersFilter;
import org.springframework.cloud.sleuth.instrument.web.client.TraceRestTemplateBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.client.TraceRestTemplateCustomizer;
import org.springframework.cloud.sleuth.instrument.web.client.TraceUserInfoRestTemplateCustomizer;
import org.springframework.cloud.sleuth.instrument.web.client.TraceWebClientBeanPostProcessor;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;

@Configuration(proxyBeanMethods=false)
@SleuthWebClientEnabled
@ConditionalOnBean(value={HttpTracing.class})
@AutoConfigureAfter(value={TraceWebServletAutoConfiguration.class})
@AutoConfigureBefore(value={HttpClientConfiguration.class})
public class TraceWebClientAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={UserInfoRestTemplateCustomizer.class, OAuth2RestTemplate.class})
    protected static class TraceOAuthConfiguration {
        protected TraceOAuthConfiguration() {
        }

        @Bean
        static UserInfoRestTemplateCustomizerBPP userInfoRestTemplateCustomizerBeanPostProcessor(BeanFactory beanFactory) {
            return new UserInfoRestTemplateCustomizerBPP(beanFactory);
        }

        @Bean
        @ConditionalOnMissingBean
        static UserInfoRestTemplateCustomizer traceUserInfoRestTemplateCustomizer(BeanFactory beanFactory) {
            return new TraceUserInfoRestTemplateCustomizer(beanFactory);
        }

        private static class UserInfoRestTemplateCustomizerBPP
        implements BeanPostProcessor {
            private final BeanFactory beanFactory;

            UserInfoRestTemplateCustomizerBPP(BeanFactory beanFactory) {
                this.beanFactory = beanFactory;
            }

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                BeanFactory beanFactory = this.beanFactory;
                if (bean instanceof UserInfoRestTemplateCustomizer && !(bean instanceof TraceUserInfoRestTemplateCustomizer)) {
                    return new TraceUserInfoRestTemplateCustomizer(beanFactory, bean);
                }
                return bean;
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpClient.class})
    static class NettyConfiguration {
        NettyConfiguration() {
        }

        @Bean
        static HttpClientBeanPostProcessor httpClientBeanPostProcessor(ConfigurableApplicationContext springContext) {
            return new HttpClientBeanPostProcessor(springContext);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpHeadersFilter.class})
    static class HttpHeadersFilterConfig {
        HttpHeadersFilterConfig() {
        }

        @Bean
        HttpHeadersFilter traceRequestHttpHeadersFilter(HttpTracing httpTracing) {
            return TraceRequestHttpHeadersFilter.create(httpTracing);
        }

        @Bean
        HttpHeadersFilter traceResponseHttpHeadersFilter(HttpTracing httpTracing) {
            return TraceResponseHttpHeadersFilter.create(httpTracing);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={WebClient.class})
    static class WebClientConfig {
        WebClientConfig() {
        }

        @Bean
        static TraceWebClientBeanPostProcessor traceWebClientBeanPostProcessor(ConfigurableApplicationContext springContext) {
            return new TraceWebClientBeanPostProcessor(springContext);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpAsyncClientBuilder.class})
    static class HttpAsyncClientBuilderConfig {
        HttpAsyncClientBuilderConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        HttpAsyncClientBuilder traceHttpAsyncClientBuilder(HttpTracing httpTracing) {
            return TracingHttpAsyncClientBuilder.create((HttpTracing)httpTracing);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpClientBuilder.class})
    static class HttpClientBuilderConfig {
        HttpClientBuilderConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        HttpClientBuilder traceHttpClientBuilder(HttpTracing httpTracing) {
            return TracingHttpClientBuilder.create((HttpTracing)httpTracing);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RestTemplate.class})
    static class RestTemplateConfig {
        RestTemplateConfig() {
        }

        @Bean
        public TracingClientHttpRequestInterceptor tracingClientHttpRequestInterceptor(HttpTracing httpTracing) {
            return (TracingClientHttpRequestInterceptor)TracingClientHttpRequestInterceptor.create((HttpTracing)httpTracing);
        }

        @Configuration(proxyBeanMethods=false)
        protected static class TraceInterceptorConfiguration {
            @Autowired
            private BeanFactory beanFactory;

            protected TraceInterceptorConfiguration() {
            }

            @Bean
            static TraceRestTemplateBeanPostProcessor traceRestTemplateBeanPostProcessor(ListableBeanFactory beanFactory) {
                return new TraceRestTemplateBeanPostProcessor((BeanFactory)beanFactory);
            }

            @Bean
            @Order
            RestTemplateCustomizer traceRestTemplateCustomizer() {
                return new TraceRestTemplateCustomizer(new LazyTracingClientHttpRequestInterceptor(this.beanFactory));
            }
        }
    }
}

