/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import brave.http.HttpTracing;
import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TracingFeignClient;

class LazyTracingFeignClient
implements Client {
    private static final Log log = LogFactory.getLog(LazyTracingFeignClient.class);
    private final BeanFactory beanFactory;
    private final Client delegate;
    private Client tracingFeignClient;
    private HttpTracing httpTracing;

    LazyTracingFeignClient(BeanFactory beanFactory, Client delegate) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending a request via tracing feign client [" + this.tracingFeignClient() + "] and the delegate [" + this.delegate + "]"));
        }
        return this.tracingFeignClient().execute(request, options);
    }

    private Client tracingFeignClient() {
        if (this.tracingFeignClient == null) {
            this.tracingFeignClient = TracingFeignClient.create(this.httpTracing(), this.delegate);
        }
        return this.tracingFeignClient;
    }

    private HttpTracing httpTracing() {
        if (this.httpTracing == null) {
            this.httpTracing = (HttpTracing)this.beanFactory.getBean(HttpTracing.class);
        }
        return this.httpTracing;
    }
}

