/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import brave.Span;
import brave.Tracer;
import brave.http.HttpTracing;
import com.netflix.client.ClientException;
import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TracingFeignClient;

public class TraceLoadBalancerFeignClient
extends LoadBalancerFeignClient {
    private static final Log log = LogFactory.getLog(TraceLoadBalancerFeignClient.class);
    private final BeanFactory beanFactory;
    Tracer tracer;
    HttpTracing httpTracing;
    TracingFeignClient tracingFeignClient;

    public TraceLoadBalancerFeignClient(Client delegate, CachingSpringLoadBalancerFactory lbClientFactory, SpringClientFactory clientFactory, BeanFactory beanFactory) {
        super(delegate, lbClientFactory, clientFactory);
        this.beanFactory = beanFactory;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Before send");
        }
        Response response = null;
        Span fallbackSpan = this.tracer().nextSpan().start();
        try {
            response = super.execute(request, options);
            if (log.isDebugEnabled()) {
                log.debug((Object)"After receive");
            }
            Response response2 = response;
            return response2;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception thrown", (Throwable)e);
            }
            if (e instanceof IOException || e.getCause() != null && e.getCause() instanceof ClientException && ((ClientException)e.getCause()).getErrorType() == ClientException.ErrorType.GENERAL) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"General exception was thrown, so most likely the traced client wasn't called. Falling back to a manual span");
                }
                this.tracingFeignClient().handleSendAndReceive(fallbackSpan, request, response, e);
            }
            throw e;
        }
        finally {
            fallbackSpan.abandon();
        }
    }

    private Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    private HttpTracing httpTracing() {
        if (this.httpTracing == null) {
            this.httpTracing = (HttpTracing)this.beanFactory.getBean(HttpTracing.class);
        }
        return this.httpTracing;
    }

    private TracingFeignClient tracingFeignClient() {
        if (this.tracingFeignClient == null) {
            this.tracingFeignClient = (TracingFeignClient)TracingFeignClient.create(this.httpTracing(), this.getDelegate());
        }
        return this.tracingFeignClient;
    }
}

