/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.propagation;

import brave.handler.FinishedSpanHandler;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.SleuthProperties;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.propagation.SleuthTagPropagationProperties;
import org.springframework.cloud.sleuth.propagation.TagPropagationFinishedSpanHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={TraceAutoConfiguration.class})
public class SleuthTagPropagationAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.sleuth.propagation.tag.enabled"}, matchIfMissing=true)
    @EnableConfigurationProperties(value={SleuthTagPropagationProperties.class})
    protected static class TagPropagationConfiguration {
        protected TagPropagationConfiguration() {
        }

        @Bean
        static FinishedSpanHandler sleuthFinishedSpanHandler(SleuthProperties sleuthProperties, SleuthTagPropagationProperties tagPropagationProperties) {
            return new TagPropagationFinishedSpanHandler(sleuthProperties, tagPropagationProperties);
        }
    }
}

