/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig;

import brave.baggage.BaggageField;
import brave.baggage.BaggagePropagation;
import brave.baggage.BaggagePropagationConfig;
import brave.baggage.BaggagePropagationCustomizer;
import brave.propagation.B3Propagation;
import brave.propagation.ExtraFieldCustomizer;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.Propagation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.SleuthProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SleuthProperties.class})
class TraceBaggageConfiguration {
    static final Log logger = LogFactory.getLog(TraceBaggageConfiguration.class);
    static final String LOCAL_KEYS = "spring.sleuth.local-keys";
    static final String BAGGAGE_KEYS = "spring.sleuth.baggage-keys";
    static final String PROPAGATION_KEYS = "spring.sleuth.propagation-keys";
    static final Propagation.Factory B3_FACTORY = B3Propagation.newFactoryBuilder().injectFormat(B3Propagation.Format.SINGLE_NO_PARENT).build();

    TraceBaggageConfiguration() {
    }

    @Bean(value={"spring.sleuth.baggage-keys"})
    @ConfigurationProperties(value="spring.sleuth.baggage-keys")
    List<String> baggageKeys() {
        return new ArrayList<String>();
    }

    @Bean(value={"spring.sleuth.local-keys"})
    @ConfigurationProperties(value="spring.sleuth.local-keys")
    List<String> localKeys() {
        return new ArrayList<String>();
    }

    @Bean(value={"spring.sleuth.propagation-keys"})
    @ConfigurationProperties(value="spring.sleuth.propagation-keys")
    List<String> propagationKeys() {
        return new ArrayList<String>();
    }

    @Bean
    @ConditionalOnMissingBean
    BaggagePropagation.FactoryBuilder baggagePropagationFactoryBuilder() {
        return BaggagePropagation.newFactoryBuilder((Propagation.Factory)B3_FACTORY);
    }

    Propagation.Factory sleuthPropagation(ExtraFieldPropagation.FactoryBuilder extraFieldPropagationFactoryBuilder, List<String> baggageKeys, List<String> localKeys, List<String> propagationKeys, @Nullable List<ExtraFieldCustomizer> extraFieldCustomizers) {
        if (extraFieldCustomizers == null) {
            extraFieldCustomizers = Collections.emptyList();
        }
        ExtraFieldPropagation.FactoryBuilder factoryBuilder = extraFieldPropagationFactoryBuilder != null ? extraFieldPropagationFactoryBuilder : ExtraFieldPropagation.newFactoryBuilder((Propagation.Factory)B3_FACTORY);
        if (!baggageKeys.isEmpty()) {
            factoryBuilder.addPrefixedFields("baggage-", baggageKeys).addPrefixedFields("baggage_", baggageKeys);
        }
        for (String string : propagationKeys) {
            factoryBuilder.addField(string);
        }
        for (String string : localKeys) {
            factoryBuilder.addRedactedField(string);
        }
        for (ExtraFieldCustomizer extraFieldCustomizer : extraFieldCustomizers) {
            extraFieldCustomizer.customize(factoryBuilder);
        }
        return factoryBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    Propagation.Factory sleuthPropagation(@Nullable ExtraFieldPropagation.FactoryBuilder extraFieldPropagationFactoryBuilder, @Nullable List<ExtraFieldCustomizer> extraFieldCustomizers, BaggagePropagation.FactoryBuilder factoryBuilder, @Qualifier(value="spring.sleuth.baggage-keys") List<String> baggageKeys, @Qualifier(value="spring.sleuth.local-keys") List<String> localKeys, @Qualifier(value="spring.sleuth.propagation-keys") List<String> propagationKeys, @Nullable List<BaggagePropagationCustomizer> baggagePropagationCustomizers) {
        boolean useDeprecated = false;
        if (extraFieldPropagationFactoryBuilder != null) {
            logger.warn((Object)"ExtraFieldPropagation.FactoryBuilder is deprecated. Please switch to BaggagePropagation.FactoryBuilder");
            useDeprecated = true;
        }
        if (extraFieldCustomizers != null) {
            logger.warn((Object)"ExtraFieldCustomizer is deprecated. Please switch to BaggagePropagationCustomizer");
            useDeprecated = true;
        }
        if (useDeprecated) {
            return this.sleuthPropagation(extraFieldPropagationFactoryBuilder, localKeys, propagationKeys, baggageKeys, extraFieldCustomizers);
        }
        for (String fieldName : localKeys) {
            factoryBuilder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.local((BaggageField)BaggageField.create((String)fieldName)));
        }
        for (String fieldName : propagationKeys) {
            factoryBuilder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.remote((BaggageField)BaggageField.create((String)fieldName)));
        }
        for (String key : baggageKeys) {
            factoryBuilder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.newBuilder((BaggageField)BaggageField.create((String)key)).addKeyName("baggage-" + key).addKeyName("baggage_" + key).build());
        }
        if (baggagePropagationCustomizers != null) {
            for (BaggagePropagationCustomizer customizer : baggagePropagationCustomizers) {
                customizer.customize(factoryBuilder);
            }
        }
        return factoryBuilder.build();
    }
}

