/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import brave.Tracing;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cloud.sleuth.DefaultSpanNamer;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.instrument.async.ContextUtil;
import org.springframework.cloud.sleuth.instrument.async.TraceCallable;
import org.springframework.cloud.sleuth.instrument.async.TraceRunnable;
import org.springframework.core.task.AsyncTaskExecutor;

public class LazyTraceAsyncTaskExecutor
implements AsyncTaskExecutor {
    private static final Log log = LogFactory.getLog(LazyTraceAsyncTaskExecutor.class);
    private final BeanFactory beanFactory;
    private final AsyncTaskExecutor delegate;
    private Tracing tracing;
    private SpanNamer spanNamer;

    public LazyTraceAsyncTaskExecutor(BeanFactory beanFactory, AsyncTaskExecutor delegate) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
    }

    public void execute(Runnable task) {
        Runnable taskToRun = task;
        if (!ContextUtil.isContextUnusable(this.beanFactory)) {
            taskToRun = new TraceRunnable(this.tracing(), this.spanNamer(), task);
        }
        this.delegate.execute(taskToRun);
    }

    public void execute(Runnable task, long startTimeout) {
        Runnable taskToRun = task;
        if (!ContextUtil.isContextUnusable(this.beanFactory)) {
            taskToRun = new TraceRunnable(this.tracing(), this.spanNamer(), task);
        }
        this.delegate.execute(taskToRun, startTimeout);
    }

    public Future<?> submit(Runnable task) {
        Runnable taskToRun = task;
        if (!ContextUtil.isContextUnusable(this.beanFactory)) {
            taskToRun = new TraceRunnable(this.tracing(), this.spanNamer(), task);
        }
        return this.delegate.submit(taskToRun);
    }

    public <T> Future<T> submit(Callable<T> task) {
        Callable<T> taskToRun = task;
        if (!ContextUtil.isContextUnusable(this.beanFactory)) {
            taskToRun = new TraceCallable<T>(this.tracing(), this.spanNamer(), task);
        }
        return this.delegate.submit(taskToRun);
    }

    private SpanNamer spanNamer() {
        if (this.spanNamer == null) {
            try {
                this.spanNamer = (SpanNamer)this.beanFactory.getBean(SpanNamer.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                log.warn((Object)"SpanNamer bean not found - will provide a manually created instance");
                return new DefaultSpanNamer();
            }
        }
        return this.spanNamer;
    }

    private Tracing tracing() {
        if (this.tracing == null) {
            try {
                this.tracing = (Tracing)this.beanFactory.getBean(Tracing.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                return null;
            }
        }
        return this.tracing;
    }
}

