/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.Tracing;
import brave.http.HttpClientParser;
import brave.http.HttpRequest;
import brave.http.HttpRequestParser;
import brave.http.HttpResponseParser;
import brave.http.HttpSampler;
import brave.http.HttpServerParser;
import brave.http.HttpTracing;
import brave.http.HttpTracingCustomizer;
import brave.sampler.SamplerFunction;
import brave.sampler.SamplerFunctions;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.ClientSampler;
import org.springframework.cloud.sleuth.instrument.web.CompositeHttpSampler;
import org.springframework.cloud.sleuth.instrument.web.HttpClientRequestParser;
import org.springframework.cloud.sleuth.instrument.web.HttpClientResponseParser;
import org.springframework.cloud.sleuth.instrument.web.HttpClientSampler;
import org.springframework.cloud.sleuth.instrument.web.HttpServerRequestParser;
import org.springframework.cloud.sleuth.instrument.web.HttpServerResponseParser;
import org.springframework.cloud.sleuth.instrument.web.HttpServerSampler;
import org.springframework.cloud.sleuth.instrument.web.ServerSampler;
import org.springframework.cloud.sleuth.instrument.web.SkipPatternHttpClientSampler;
import org.springframework.cloud.sleuth.instrument.web.SkipPatternHttpServerSampler;
import org.springframework.cloud.sleuth.instrument.web.SkipPatternProvider;
import org.springframework.cloud.sleuth.instrument.web.SleuthHttpClientParser;
import org.springframework.cloud.sleuth.instrument.web.SleuthHttpServerParser;
import org.springframework.cloud.sleuth.instrument.web.SleuthWebProperties;
import org.springframework.cloud.sleuth.instrument.web.TraceKeys;
import org.springframework.cloud.sleuth.instrument.web.TraceWebAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.lang.Nullable;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.sleuth.http.enabled", "spring.sleuth.web.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnBean(value={Tracing.class})
@ConditionalOnClass(value={HttpTracing.class})
@AutoConfigureAfter(value={TraceAutoConfiguration.class})
@Import(value={TraceWebAutoConfiguration.class})
@EnableConfigurationProperties(value={TraceKeys.class})
public class TraceHttpAutoConfiguration {
    static final int TRACING_FILTER_ORDER = -2147483643;

    @Bean
    @ConditionalOnMissingBean
    HttpTracing httpTracing(Tracing tracing, @Nullable SkipPatternProvider provider, @Nullable @HttpClientRequestParser HttpRequestParser httpClientRequestParser, @Nullable @HttpClientResponseParser HttpResponseParser httpClientResponseParser, @Nullable HttpClientParser clientParser, @Nullable @HttpServerRequestParser HttpRequestParser httpServerRequestParser, @Nullable @HttpServerResponseParser HttpResponseParser httpServerResponseParser, @Nullable HttpServerParser serverParser, @HttpClientSampler SamplerFunction<HttpRequest> httpClientSampler, @Nullable @ServerSampler HttpSampler serverSampler, @Nullable @HttpServerSampler SamplerFunction<HttpRequest> httpServerSampler, @Nullable List<HttpTracingCustomizer> httpTracingCustomizers) {
        if (httpServerSampler == null) {
            httpServerSampler = serverSampler;
        }
        SamplerFunction<HttpRequest> combinedSampler = this.combineUserProvidedSamplerWithSkipPatternSampler((SamplerFunction<HttpRequest>)httpServerSampler, provider);
        HttpTracing.Builder builder = HttpTracing.newBuilder((Tracing)tracing).clientSampler(httpClientSampler).serverSampler(combinedSampler);
        if (httpClientRequestParser != null || httpClientResponseParser != null) {
            if (httpClientRequestParser != null) {
                builder.clientRequestParser(httpClientRequestParser);
            }
            if (httpClientResponseParser != null) {
                builder.clientResponseParser(httpClientResponseParser);
            }
        } else if (clientParser != null) {
            builder.clientParser(clientParser);
        }
        if (httpServerRequestParser != null || httpServerResponseParser != null) {
            if (httpServerRequestParser != null) {
                builder.serverRequestParser(httpServerRequestParser);
            }
            if (httpServerResponseParser != null) {
                builder.serverResponseParser(httpServerResponseParser);
            }
        } else if (serverParser != null) {
            builder.serverParser(serverParser);
        }
        if (httpTracingCustomizers != null) {
            for (HttpTracingCustomizer customizer : httpTracingCustomizers) {
                customizer.customize(builder);
            }
        }
        return builder.build();
    }

    private SamplerFunction<HttpRequest> combineUserProvidedSamplerWithSkipPatternSampler(@Nullable SamplerFunction<HttpRequest> serverSampler, @Nullable SkipPatternProvider provider) {
        SkipPatternHttpServerSampler skipPatternSampler;
        SkipPatternHttpServerSampler skipPatternHttpServerSampler = skipPatternSampler = provider != null ? new SkipPatternHttpServerSampler(provider) : null;
        if (serverSampler == null && skipPatternSampler == null) {
            return SamplerFunctions.deferDecision();
        }
        if (serverSampler == null) {
            return skipPatternSampler;
        }
        if (skipPatternSampler == null) {
            return serverSampler;
        }
        return new CompositeHttpSampler(skipPatternSampler, serverSampler);
    }

    @Bean
    @ConditionalOnMissingBean(name={"sleuthHttpClientRequestParser"})
    @ConditionalOnProperty(name={"spring.sleuth.http.legacy.enabled"}, havingValue="true")
    HttpRequestParser sleuthHttpClientRequestParser(TraceKeys traceKeys) {
        return new SleuthHttpClientParser(traceKeys);
    }

    @Bean
    @ConditionalOnMissingBean(name={"sleuthHttpServerRequestParser"})
    @ConditionalOnProperty(name={"spring.sleuth.http.legacy.enabled"}, havingValue="true")
    HttpRequestParser sleuthHttpServerRequestParser(TraceKeys traceKeys) {
        return new SleuthHttpServerParser(traceKeys);
    }

    @Bean
    @ConditionalOnMissingBean(name={"sleuthHttpServerResponseParser"})
    @ConditionalOnProperty(name={"spring.sleuth.http.legacy.enabled"}, havingValue="true")
    HttpResponseParser sleuthHttpServerResponseParser(TraceKeys traceKeys) {
        return new SleuthHttpServerParser(traceKeys);
    }

    @Bean
    @ConditionalOnMissingBean(name={"sleuthHttpClientSampler"})
    SamplerFunction<HttpRequest> sleuthHttpClientSampler(@Nullable @ClientSampler HttpSampler sleuthClientSampler, SleuthWebProperties sleuthWebProperties) {
        if (sleuthClientSampler != null) {
            return sleuthClientSampler;
        }
        String skipPattern = sleuthWebProperties.getClient().getSkipPattern();
        if (skipPattern == null) {
            return SamplerFunctions.deferDecision();
        }
        return new SkipPatternHttpClientSampler(Pattern.compile(skipPattern));
    }
}

