/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.Tracing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.EndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.SingleSkipPattern;
import org.springframework.cloud.sleuth.instrument.web.SkipPatternProvider;
import org.springframework.cloud.sleuth.instrument.web.SleuthWebProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Deprecated
@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.web.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={Tracing.class})
@AutoConfigureAfter(value={TraceAutoConfiguration.class})
@EnableConfigurationProperties(value={SleuthWebProperties.class})
public class TraceWebAutoConfiguration {
    @Autowired(required=false)
    List<SingleSkipPattern> patterns = new ArrayList<SingleSkipPattern>();

    @Bean
    @ConditionalOnMissingBean
    SkipPatternProvider sleuthSkipPatternProvider() {
        if (this.patterns == null) {
            return null;
        }
        List presentPatterns = this.patterns.stream().map(SingleSkipPattern::skipPattern).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (presentPatterns.isEmpty()) {
            return null;
        }
        if (presentPatterns.size() == 1) {
            Pattern pattern = (Pattern)presentPatterns.get(0);
            return () -> pattern;
        }
        StringJoiner joiner = new StringJoiner("|");
        for (Pattern pattern : presentPatterns) {
            String s = pattern.pattern();
            joiner.add(s);
        }
        Pattern pattern = Pattern.compile(joiner.toString());
        return () -> pattern;
    }

    @Configuration(proxyBeanMethods=false)
    static class DefaultSkipPatternConfig {
        DefaultSkipPatternConfig() {
        }

        @Bean
        SingleSkipPattern defaultSkipPatternBean(SleuthWebProperties sleuthWebProperties) {
            Pattern pattern = DefaultSkipPatternConfig.combinePatterns(sleuthWebProperties.getSkipPattern(), sleuthWebProperties.getAdditionalSkipPattern());
            return () -> Optional.ofNullable(pattern);
        }

        private static Pattern combinePatterns(String left, String right) {
            if (left == null && right == null) {
                return null;
            }
            if (left == null) {
                return Pattern.compile(right);
            }
            if (right == null) {
                return Pattern.compile(left);
            }
            return Pattern.compile(left + "|" + right);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ServerProperties.class, EndpointsSupplier.class, ExposableWebEndpoint.class})
    @ConditionalOnBean(value={ServerProperties.class})
    @ConditionalOnProperty(value={"spring.sleuth.web.ignoreAutoConfiguredSkipPatterns"}, havingValue="false", matchIfMissing=true)
    protected static class ActuatorSkipPatternProviderConfig {
        protected ActuatorSkipPatternProviderConfig() {
        }

        static Optional<Pattern> getEndpointsPatterns(String contextPath, WebEndpointProperties webEndpointProperties, EndpointsSupplier<ExposableWebEndpoint> endpointsSupplier) {
            Collection endpoints = endpointsSupplier.getEndpoints();
            if (endpoints.isEmpty()) {
                return Optional.empty();
            }
            String basePath = webEndpointProperties.getBasePath();
            String pattern = ActuatorSkipPatternProviderConfig.patternFromEndpoints(contextPath, endpoints, basePath);
            if (StringUtils.hasText((String)pattern)) {
                return Optional.of(Pattern.compile(pattern));
            }
            return Optional.empty();
        }

        private static String patternFromEndpoints(String contextPath, Collection<ExposableWebEndpoint> endpoints, String basePath) {
            StringJoiner joiner = new StringJoiner("|", ActuatorSkipPatternProviderConfig.getPathPrefix(contextPath, basePath), ActuatorSkipPatternProviderConfig.getPathSuffix(contextPath, basePath));
            for (ExposableWebEndpoint endpoint : endpoints) {
                String path = endpoint.getRootPath();
                String paths = path + "|" + path + "/.*";
                joiner.add(paths);
            }
            return joiner.toString();
        }

        private static String getPathPrefix(String contextPath, String actuatorBasePath) {
            String result = "";
            if (StringUtils.hasText((String)contextPath)) {
                result = result + contextPath;
            }
            if (!actuatorBasePath.equals("/")) {
                result = result + actuatorBasePath;
            }
            boolean ignoreBase = StringUtils.hasText((String)result) && !result.equals("/");
            String suffix = "/(";
            if (ignoreBase) {
                suffix = "(/|" + suffix;
            }
            return result + suffix;
        }

        private static String getPathSuffix(String contextPath, String actuatorBasePath) {
            String result = ")";
            if (StringUtils.hasText((String)contextPath) || StringUtils.hasText((String)actuatorBasePath) && !"/".equals(actuatorBasePath)) {
                result = result + ")?";
            }
            return result;
        }

        @Bean
        @ConditionalOnManagementPort(value=ManagementPortType.SAME)
        public SingleSkipPattern skipPatternForActuatorEndpointsSamePort(ServerProperties serverProperties, WebEndpointProperties webEndpointProperties, EndpointsSupplier<ExposableWebEndpoint> endpointsSupplier) {
            return () -> ActuatorSkipPatternProviderConfig.getEndpointsPatterns(serverProperties.getServlet().getContextPath(), webEndpointProperties, endpointsSupplier);
        }

        @Bean
        @ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
        @ConditionalOnProperty(name={"management.server.servlet.context-path"}, havingValue="/", matchIfMissing=true)
        public SingleSkipPattern skipPatternForActuatorEndpointsDifferentPort(ServerProperties serverProperties, WebEndpointProperties webEndpointProperties, EndpointsSupplier<ExposableWebEndpoint> endpointsSupplier) {
            return () -> ActuatorSkipPatternProviderConfig.getEndpointsPatterns(null, webEndpointProperties, endpointsSupplier);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ManagementServerProperties.class})
    @ConditionalOnProperty(value={"spring.sleuth.web.ignoreAutoConfiguredSkipPatterns"}, havingValue="false", matchIfMissing=true)
    protected static class ManagementSkipPatternProviderConfig {
        protected ManagementSkipPatternProviderConfig() {
        }

        static Optional<Pattern> getPatternForManagementServerProperties(ManagementServerProperties managementServerProperties) {
            String contextPath = managementServerProperties.getServlet().getContextPath();
            if (StringUtils.hasText((String)contextPath)) {
                return Optional.of(Pattern.compile(contextPath + ".*"));
            }
            return Optional.empty();
        }

        @Bean
        @ConditionalOnBean(value={ManagementServerProperties.class})
        public SingleSkipPattern skipPatternForManagementServerProperties(ManagementServerProperties managementServerProperties) {
            return () -> ManagementSkipPatternProviderConfig.getPatternForManagementServerProperties(managementServerProperties);
        }
    }
}

