/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import brave.Span;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.cloud.sleuth.internal.LazyBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class TraceExchangeFilterFunction
implements ExchangeFilterFunction {
    private static final Log log = LogFactory.getLog(TraceExchangeFilterFunction.class);
    final LazyBean<HttpTracing> httpTracing;
    final Function<? super Publisher<DataBuffer>, ? extends Publisher<DataBuffer>> scopePassingTransformer;
    HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;
    CurrentTraceContext currentTraceContext;

    TraceExchangeFilterFunction(ConfigurableApplicationContext springContext) {
        this.httpTracing = LazyBean.create(springContext, HttpTracing.class);
        this.scopePassingTransformer = ReactorSleuth.scopePassingSpanOperator(springContext);
    }

    public static ExchangeFilterFunction create(ConfigurableApplicationContext springContext) {
        return new TraceExchangeFilterFunction(springContext);
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        return new MonoWebClientTrace(next, request, this);
    }

    CurrentTraceContext currentTraceContext() {
        if (this.currentTraceContext == null) {
            this.currentTraceContext = this.httpTracing.get().tracing().currentTraceContext();
        }
        return this.currentTraceContext;
    }

    HttpClientHandler<HttpClientRequest, HttpClientResponse> handler() {
        if (this.handler == null) {
            this.handler = HttpClientHandler.create((HttpTracing)this.httpTracing.get());
        }
        return this.handler;
    }

    static final class ClientResponseWrapper
    extends HttpClientResponse {
        final ClientResponse delegate;

        ClientResponseWrapper(ClientResponse delegate) {
            this.delegate = delegate;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public int statusCode() {
            return Math.max(this.delegate.rawStatusCode(), 0);
        }
    }

    private static final class ClientRequestWrapper
    extends HttpClientRequest {
        final ClientRequest delegate;
        final ClientRequest.Builder builder;

        ClientRequestWrapper(ClientRequest delegate) {
            this.delegate = delegate;
            this.builder = ClientRequest.from((ClientRequest)delegate);
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.method().name();
        }

        public String path() {
            return this.delegate.url().getPath();
        }

        public String url() {
            return this.delegate.url().toString();
        }

        public String header(String name) {
            return this.delegate.headers().getFirst(name);
        }

        public void header(String name, String value) {
            this.builder.header(name, new String[]{value});
        }

        ClientRequest buildRequest() {
            return this.builder.build();
        }
    }

    static class TraceWebClientSubscription
    implements Subscription {
        static final Exception CANCELLED_ERROR = new CancellationException("CANCELLED"){

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        };
        final AtomicReference<Span> pendingSpan;
        final Subscription delegate;
        volatile boolean requested;

        TraceWebClientSubscription(Subscription delegate, AtomicReference<Span> pendingSpan) {
            this.delegate = delegate;
            this.pendingSpan = pendingSpan;
        }

        public void request(long n) {
            this.requested = true;
            this.delegate.request(n);
        }

        public void cancel() {
            this.delegate.cancel();
            Span span = this.pendingSpan.getAndSet(null);
            if (span != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Subscription was cancelled. TraceWebClientBeanPostProcessor Will close the span [" + span + "]"));
                }
                if (!this.requested) {
                    span.abandon();
                } else {
                    span.error((Throwable)CANCELLED_ERROR);
                    span.finish();
                }
            }
        }
    }

    static final class TraceWebClientSubscriber
    extends AtomicReference<Span>
    implements CoreSubscriber<ClientResponse> {
        final CoreSubscriber<? super ClientResponse> actual;
        final Context context;
        @Nullable
        final TraceContext parent;
        final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;
        final Function<? super Publisher<DataBuffer>, ? extends Publisher<DataBuffer>> scopePassingTransformer;
        final CurrentTraceContext currentTraceContext;

        TraceWebClientSubscriber(CoreSubscriber<? super ClientResponse> actual, Context ctx, Span clientSpan, MonoWebClientTrace mono) {
            this.actual = actual;
            this.parent = mono.parent;
            this.handler = mono.handler;
            this.currentTraceContext = mono.currentTraceContext;
            this.scopePassingTransformer = mono.scopePassingTransformer;
            this.context = this.parent != null && !this.parent.equals(ctx.getOrDefault(TraceContext.class, null)) ? ctx.put(TraceContext.class, (Object)this.parent) : ctx;
            this.set(clientSpan);
        }

        public void onSubscribe(Subscription subscription) {
            this.actual.onSubscribe((Subscription)new TraceWebClientSubscription(subscription, this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(ClientResponse response) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.parent);){
                this.actual.onNext((Object)ClientResponse.from((ClientResponse)response).body(response.bodyToFlux(DataBuffer.class).transform(this.scopePassingTransformer)).build());
            }
            finally {
                Span span = this.getAndSet(null);
                if (span != null) {
                    this.handler.handleReceive((Object)new ClientResponseWrapper(response), null, span);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable t) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.parent);){
                this.actual.onError(t);
            }
            finally {
                Span span = this.getAndSet(null);
                if (span != null) {
                    span.error(t);
                    span.finish();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.parent);){
                this.actual.onComplete();
            }
            finally {
                Span span = this.getAndSet(null);
                if (span != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Reached OnComplete without finishing [" + span + "]"));
                    }
                    span.abandon();
                }
            }
        }

        public Context currentContext() {
            return this.context;
        }
    }

    private static final class MonoWebClientTrace
    extends Mono<ClientResponse> {
        final ExchangeFunction next;
        final ClientRequest request;
        final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;
        final CurrentTraceContext currentTraceContext;
        final Function<? super Publisher<DataBuffer>, ? extends Publisher<DataBuffer>> scopePassingTransformer;
        @Nullable
        final TraceContext parent;

        MonoWebClientTrace(ExchangeFunction next, ClientRequest request, TraceExchangeFilterFunction filterFunction) {
            this.next = next;
            this.request = request;
            this.handler = filterFunction.handler();
            this.currentTraceContext = filterFunction.currentTraceContext();
            this.scopePassingTransformer = filterFunction.scopePassingTransformer;
            this.parent = this.currentTraceContext.get();
        }

        public void subscribe(CoreSubscriber<? super ClientResponse> subscriber) {
            Context context = subscriber.currentContext();
            ClientRequestWrapper wrapper = new ClientRequestWrapper(this.request);
            Span span = this.handler.handleSendWithParent((HttpClientRequest)wrapper, this.parent);
            if (log.isDebugEnabled()) {
                log.debug((Object)("HttpClientHandler::handleSend: " + span));
            }
            this.next.exchange(wrapper.buildRequest()).subscribe((CoreSubscriber)new TraceWebClientSubscriber(subscriber, context, span, this));
        }
    }
}

