/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig;

import brave.CurrentSpanCustomizer;
import brave.ErrorParser;
import brave.Tracer;
import brave.Tracing;
import brave.TracingCustomizer;
import brave.handler.SpanHandler;
import brave.propagation.CurrentTraceContext;
import brave.propagation.CurrentTraceContextCustomizer;
import brave.propagation.Propagation;
import brave.propagation.ThreadLocalCurrentTraceContext;
import brave.sampler.Sampler;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.DefaultSpanNamer;
import org.springframework.cloud.sleuth.LocalServiceName;
import org.springframework.cloud.sleuth.SpanAdjuster;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.autoconfig.SleuthBaggageProperties;
import org.springframework.cloud.sleuth.autoconfig.SleuthProperties;
import org.springframework.cloud.sleuth.autoconfig.TraceBaggageConfiguration;
import org.springframework.cloud.sleuth.log.SleuthLogAutoConfiguration;
import org.springframework.cloud.sleuth.sampler.SamplerAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import zipkin2.Span;
import zipkin2.reporter.InMemoryReporterMetrics;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.ReporterMetrics;
import zipkin2.reporter.brave.ZipkinSpanHandler;
import zipkin2.reporter.metrics.micrometer.MicrometerReporterMetrics;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={SleuthProperties.class, SleuthBaggageProperties.class})
@Import(value={SleuthLogAutoConfiguration.class, TraceBaggageConfiguration.class, SamplerAutoConfiguration.class})
public class TraceAutoConfiguration {
    public static final String TRACER_BEAN_NAME = "tracer";
    public static final String DEFAULT_SERVICE_NAME = "default";
    static final Comparator<SpanHandler> SPAN_HANDLER_COMPARATOR = (o1, o2) -> {
        if (o1 instanceof ZipkinSpanHandler) {
            if (o2 instanceof ZipkinSpanHandler) {
                return 0;
            }
            return 1;
        }
        if (o2 instanceof ZipkinSpanHandler) {
            return -1;
        }
        return 0;
    };

    @Bean
    @ConditionalOnMissingBean
    Tracing tracing(@LocalServiceName String serviceName, Propagation.Factory factory, CurrentTraceContext currentTraceContext, Sampler sampler, ErrorParser errorParser, SleuthProperties sleuthProperties, @Nullable List<Reporter<Span>> spanReporters, @Nullable List<SpanAdjuster> spanAdjusters, @Nullable List<SpanHandler> spanHandlers, @Nullable List<TracingCustomizer> tracingCustomizers) {
        if (spanAdjusters == null) {
            spanAdjusters = Collections.emptyList();
        }
        Tracing.Builder builder = Tracing.newBuilder().sampler(sampler).errorParser(errorParser).localServiceName(StringUtils.isEmpty((Object)serviceName) ? DEFAULT_SERVICE_NAME : serviceName).propagationFactory(factory).currentTraceContext(currentTraceContext).spanReporter((Reporter)new CompositeReporter(spanAdjusters, spanReporters != null ? spanReporters : Collections.emptyList())).traceId128Bit(sleuthProperties.isTraceId128()).supportsJoin(sleuthProperties.isSupportsJoin());
        if (spanHandlers != null) {
            for (SpanHandler spanHandlerFactory : spanHandlers) {
                builder.addSpanHandler(spanHandlerFactory);
            }
        }
        if (tracingCustomizers != null) {
            for (TracingCustomizer customizer : tracingCustomizers) {
                customizer.customize(builder);
            }
        }
        this.reorderZipkinHandlersLast(builder);
        return builder.build();
    }

    private void reorderZipkinHandlersLast(Tracing.Builder builder) {
        ArrayList<SpanHandler> configuredSpanHandlers = new ArrayList<SpanHandler>(builder.spanHandlers());
        configuredSpanHandlers.sort(SPAN_HANDLER_COMPARATOR);
        builder.clearSpanHandlers();
        for (SpanHandler spanHandler : configuredSpanHandlers) {
            builder.addSpanHandler(spanHandler);
        }
    }

    @Bean(name={"tracer"})
    @ConditionalOnMissingBean
    Tracer tracer(Tracing tracing) {
        return tracing.tracer();
    }

    @Bean
    @ConditionalOnMissingBean
    SpanNamer sleuthSpanNamer() {
        return new DefaultSpanNamer();
    }

    @Bean
    CurrentTraceContext sleuthCurrentTraceContext(CurrentTraceContext.Builder builder, @Nullable List<CurrentTraceContext.ScopeDecorator> scopeDecorators, @Nullable List<CurrentTraceContextCustomizer> currentTraceContextCustomizers) {
        if (scopeDecorators == null) {
            scopeDecorators = Collections.emptyList();
        }
        if (currentTraceContextCustomizers == null) {
            currentTraceContextCustomizers = Collections.emptyList();
        }
        for (CurrentTraceContext.ScopeDecorator scopeDecorator : scopeDecorators) {
            builder.addScopeDecorator(scopeDecorator);
        }
        for (CurrentTraceContextCustomizer currentTraceContextCustomizer : currentTraceContextCustomizers) {
            currentTraceContextCustomizer.customize(builder);
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    CurrentTraceContext.Builder sleuthCurrentTraceContextBuilder() {
        return ThreadLocalCurrentTraceContext.newBuilder();
    }

    @Bean
    @ConditionalOnMissingBean
    Reporter<Span> noOpSpanReporter() {
        return Reporter.NOOP;
    }

    @Bean
    @ConditionalOnMissingBean
    ErrorParser errorParser() {
        return new ErrorParser();
    }

    @Bean
    @ConditionalOnMissingBean
    CurrentSpanCustomizer spanCustomizer(Tracing tracing) {
        return CurrentSpanCustomizer.create((Tracing)tracing);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MeterRegistry.class})
    static class TraceMetricsMicrometerConfiguration {
        TraceMetricsMicrometerConfiguration() {
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnMissingBean(value={ReporterMetrics.class})
        static class NoReporterMetricsBeanConfiguration {
            NoReporterMetricsBeanConfiguration() {
            }

            @Bean
            @ConditionalOnBean(value={MeterRegistry.class})
            ReporterMetrics sleuthMicrometerReporterMetrics(MeterRegistry meterRegistry) {
                return MicrometerReporterMetrics.create((MeterRegistry)meterRegistry);
            }

            @Bean
            @ConditionalOnMissingBean(value={MeterRegistry.class})
            ReporterMetrics sleuthReporterMetrics() {
                return new InMemoryReporterMetrics();
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"io.micrometer.core.instrument.MeterRegistry"})
    static class TraceMetricsInMemoryConfiguration {
        TraceMetricsInMemoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ReporterMetrics sleuthReporterMetrics() {
            return new InMemoryReporterMetrics();
        }
    }

    private static final class CompositeReporter
    implements Reporter<Span> {
        private static final Log log = LogFactory.getLog(CompositeReporter.class);
        private final List<SpanAdjuster> spanAdjusters;
        private final Reporter<Span> spanReporter;

        private CompositeReporter(List<SpanAdjuster> spanAdjusters, List<Reporter<Span>> spanReporters) {
            Reporter<Span> reporter;
            this.spanAdjusters = spanAdjusters;
            if (spanReporters.size() == 1) {
                reporter = spanReporters.get(0);
            } else {
                Reporter<Span> reporter2;
                reporter = reporter2;
                super(spanReporters);
            }
            this.spanReporter = reporter;
        }

        public void report(Span span) {
            Span spanToAdjust = span;
            for (SpanAdjuster spanAdjuster : this.spanAdjusters) {
                spanToAdjust = spanAdjuster.adjust(spanToAdjust);
            }
            this.spanReporter.report((Object)spanToAdjust);
        }

        public String toString() {
            return "CompositeReporter{spanAdjusters=" + this.spanAdjusters + ", spanReporters=" + this.spanReporter + '}';
        }

        private static final class ListReporter
        implements Reporter<Span> {
            private final List<Reporter<Span>> spanReporters;

            private ListReporter(List<Reporter<Span>> spanReporters) {
                this.spanReporters = spanReporters;
            }

            public void report(Span span) {
                for (Reporter<Span> spanReporter : this.spanReporters) {
                    try {
                        spanReporter.report((Object)span);
                    }
                    catch (Exception ex) {
                        log.warn((Object)("Exception occurred while trying to report the span " + span), (Throwable)ex);
                    }
                }
            }

            public String toString() {
                return "ListReporter{spanReporters=" + this.spanReporters + '}';
            }
        }
    }
}

