/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.LazyTracingFeignClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignBlockingLoadBalancerClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceLoadBalancerFeignClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TracingFeignClient;
import org.springframework.cloud.util.ProxyUtils;
import org.springframework.util.ClassUtils;

final class TraceFeignObjectWrapper {
    public static final String EXCEPTION_WARNING = "Exception occurred while trying to access the delegate's field. Will fallback to default instrumentation mechanism, which means that the delegate might not be instrumented";
    private static final boolean ribbonPresent;
    private static final Log log;
    private static final boolean loadBalancerPresent;
    private static final String DELEGATE = "delegate";
    private final BeanFactory beanFactory;
    private CachingSpringLoadBalancerFactory cachingSpringLoadBalancerFactory;
    private Object springClientFactory;
    private Object loadBalancerClient;

    TraceFeignObjectWrapper(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    Object wrap(Object bean) {
        if (bean instanceof Client && !(bean instanceof TracingFeignClient)) {
            if (ribbonPresent && bean instanceof LoadBalancerFeignClient && !(bean instanceof TraceLoadBalancerFeignClient)) {
                return this.instrumentedFeignRibbonClient(bean);
            }
            if (ribbonPresent && bean instanceof TraceLoadBalancerFeignClient) {
                return bean;
            }
            if (loadBalancerPresent && bean instanceof FeignBlockingLoadBalancerClient && !(bean instanceof TraceFeignBlockingLoadBalancerClient)) {
                return this.instrumentedFeignLoadBalancerClient(bean);
            }
            if (ribbonPresent && bean instanceof TraceFeignBlockingLoadBalancerClient) {
                return bean;
            }
            return new LazyTracingFeignClient(this.beanFactory, (Client)bean);
        }
        return bean;
    }

    private Object instrumentedFeignLoadBalancerClient(Object bean) {
        if (AopUtils.getTargetClass((Object)bean).equals(FeignBlockingLoadBalancerClient.class)) {
            FeignBlockingLoadBalancerClient client = (FeignBlockingLoadBalancerClient)ProxyUtils.getTargetObject((Object)bean);
            return new TraceFeignBlockingLoadBalancerClient((Client)new TraceFeignObjectWrapper(this.beanFactory).wrap(client.getDelegate()), (BlockingLoadBalancerClient)this.loadBalancerClient(), this.beanFactory);
        }
        FeignBlockingLoadBalancerClient client = (FeignBlockingLoadBalancerClient)bean;
        try {
            Field delegate = FeignBlockingLoadBalancerClient.class.getDeclaredField(DELEGATE);
            delegate.setAccessible(true);
            delegate.set(client, new TraceFeignObjectWrapper(this.beanFactory).wrap(client.getDelegate()));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            log.warn((Object)EXCEPTION_WARNING, (Throwable)e);
        }
        return new TraceFeignBlockingLoadBalancerClient((Client)client, (BlockingLoadBalancerClient)this.loadBalancerClient(), this.beanFactory);
    }

    private Object instrumentedFeignRibbonClient(Object bean) {
        if (AopUtils.getTargetClass((Object)bean).equals(LoadBalancerFeignClient.class)) {
            LoadBalancerFeignClient client = (LoadBalancerFeignClient)bean;
            return new TraceLoadBalancerFeignClient((Client)new TraceFeignObjectWrapper(this.beanFactory).wrap(client.getDelegate()), this.factory(), (SpringClientFactory)this.clientFactory(), this.beanFactory);
        }
        LoadBalancerFeignClient client = (LoadBalancerFeignClient)bean;
        try {
            Field delegate = LoadBalancerFeignClient.class.getDeclaredField(DELEGATE);
            delegate.setAccessible(true);
            delegate.set(client, new TraceFeignObjectWrapper(this.beanFactory).wrap(client.getDelegate()));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            log.warn((Object)EXCEPTION_WARNING, (Throwable)e);
        }
        return new TraceLoadBalancerFeignClient((Client)client, this.factory(), (SpringClientFactory)this.clientFactory(), this.beanFactory);
    }

    private CachingSpringLoadBalancerFactory factory() {
        if (this.cachingSpringLoadBalancerFactory == null) {
            this.cachingSpringLoadBalancerFactory = (CachingSpringLoadBalancerFactory)this.beanFactory.getBean(CachingSpringLoadBalancerFactory.class);
        }
        return this.cachingSpringLoadBalancerFactory;
    }

    private Object clientFactory() {
        if (this.springClientFactory == null) {
            this.springClientFactory = this.beanFactory.getBean(SpringClientFactory.class);
        }
        return this.springClientFactory;
    }

    private Object loadBalancerClient() {
        if (this.loadBalancerClient == null) {
            this.loadBalancerClient = this.beanFactory.getBean(BlockingLoadBalancerClient.class);
        }
        return this.loadBalancerClient;
    }

    static {
        log = LogFactory.getLog(TraceFeignObjectWrapper.class);
        ribbonPresent = ClassUtils.isPresent((String)"org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient", null) && ClassUtils.isPresent((String)"org.springframework.cloud.netflix.ribbon.SpringClientFactory", null);
        loadBalancerPresent = ClassUtils.isPresent((String)"org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient", null) && ClassUtils.isPresent((String)"org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient", null);
    }
}

