/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.sleuth.instrument.reactor.ScopePassingSpanSubscriber;
import org.springframework.cloud.sleuth.internal.LazyBean;
import org.springframework.context.ConfigurableApplicationContext;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

public abstract class ReactorSleuth {
    private static final Log log = LogFactory.getLog(ReactorSleuth.class);

    private ReactorSleuth() {
    }

    public static <T> Function<? super Publisher<T>, ? extends Publisher<T>> scopePassingSpanOperator(ConfigurableApplicationContext springContext) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Scope passing operator [" + springContext + "]"));
        }
        LazyBean<CurrentTraceContext> lazyCurrentTraceContext = LazyBean.create(springContext, CurrentTraceContext.class);
        return Operators.liftPublisher((p, sub) -> {
            CurrentTraceContext currentTraceContext;
            if (p instanceof Fuseable.ScalarCallable) {
                return sub;
            }
            if (!springContext.isActive()) {
                if (log.isTraceEnabled()) {
                    String message = "Spring Context [" + springContext + "] is not yet refreshed. This is unexpected. Reactor Context is [" + ReactorSleuth.context(sub) + "] and name is [" + ReactorSleuth.name(sub) + "]";
                    log.trace((Object)message);
                }
                return sub;
            }
            Context context = ReactorSleuth.context(sub);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Spring context [" + springContext + "], Reactor context [" + context + "], name [" + ReactorSleuth.name(sub) + "]"));
            }
            if ((currentTraceContext = (CurrentTraceContext)lazyCurrentTraceContext.get()) == null) {
                boolean assertOn = false;
                if (!$assertionsDisabled) {
                    assertOn = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (log.isTraceEnabled() || assertOn) {
                    String message = "Spring Context [" + springContext + "] did not return a CurrentTraceContext. Reactor Context is [" + ReactorSleuth.context(sub) + "] and name is [" + ReactorSleuth.name(sub) + "]";
                    log.trace((Object)message);
                    assert (false) : message;
                }
                return sub;
            }
            TraceContext parent = ReactorSleuth.traceContext(context, currentTraceContext);
            if (parent == null) {
                return sub;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Creating a scope passing span subscriber with Reactor Context [" + context + "] and name [" + ReactorSleuth.name(sub) + "]"));
            }
            return new ScopePassingSpanSubscriber(sub, context, currentTraceContext, parent);
        });
    }

    private static <T> Context context(CoreSubscriber<? super T> sub) {
        try {
            return sub.currentContext();
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception occurred while trying to retrieve the context", (Throwable)ex);
            }
            return Context.empty();
        }
    }

    static String name(CoreSubscriber<?> sub) {
        return Scannable.from(sub).name();
    }

    static TraceContext traceContext(Context context, CurrentTraceContext fallback) {
        if (context.hasKey(TraceContext.class)) {
            return (TraceContext)context.get(TraceContext.class);
        }
        return fallback.get();
    }
}

