/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.SpanCustomizer;
import brave.http.HttpRequest;
import brave.http.HttpRequestParser;
import brave.propagation.TraceContext;
import java.net.URI;
import org.springframework.cloud.sleuth.instrument.web.TraceKeys;
import org.springframework.cloud.sleuth.util.SpanNameUtil;

class SleuthHttpClientParser
implements HttpRequestParser {
    private static final String HOST_KEY = "http.host";
    private static final String METHOD_KEY = "http.method";
    private static final String PATH_KEY = "http.path";
    private static final String URL_KEY = "http.url";
    private final TraceKeys traceKeys;

    SleuthHttpClientParser(TraceKeys traceKeys) {
        this.traceKeys = traceKeys;
    }

    public void parse(HttpRequest request, TraceContext context, SpanCustomizer span) {
        HttpRequestParser.DEFAULT.parse(request, context, span);
        String url = request.url();
        if (url != null) {
            URI uri = URI.create(url);
            span.name(this.getName(uri));
            this.addRequestTags(span, url, uri.getHost(), uri.getPath(), request.method());
        }
        for (String header : this.traceKeys.getHttp().getHeaders()) {
            String headerValue = request.header(header);
            if (headerValue == null) continue;
            span.tag(this.key(header), headerValue);
        }
    }

    private String key(String key) {
        return this.traceKeys.getHttp().getPrefix() + key.toLowerCase();
    }

    private String getName(URI uri) {
        return SpanNameUtil.shorten(this.uriScheme(uri) + ":" + uri.getRawPath());
    }

    private String uriScheme(URI uri) {
        return uri.getScheme() == null ? "http" : uri.getScheme();
    }

    private void addRequestTags(SpanCustomizer span, String url, String host, String path, String method) {
        span.tag(URL_KEY, url);
        if (host != null) {
            span.tag(HOST_KEY, host);
        }
        span.tag(PATH_KEY, path);
        span.tag(METHOD_KEY, method);
    }
}

