/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import brave.Tracing;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cloud.sleuth.DefaultSpanNamer;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.instrument.async.TraceCallable;
import org.springframework.cloud.sleuth.instrument.async.TraceRunnable;
import org.springframework.cloud.sleuth.internal.ContextUtil;
import org.springframework.util.ReflectionUtils;

class LazyTraceScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private static final Log log = LogFactory.getLog(LazyTraceScheduledThreadPoolExecutor.class);
    private final BeanFactory beanFactory;
    private final ScheduledThreadPoolExecutor delegate;
    private final Method decorateTaskRunnable;
    private final Method decorateTaskCallable;
    private final Method finalize;
    private final Method beforeExecute;
    private final Method afterExecute;
    private final Method terminated;
    private final Method newTaskForRunnable;
    private final Method newTaskForCallable;
    private Tracing tracing;
    private SpanNamer spanNamer;

    LazyTraceScheduledThreadPoolExecutor(int corePoolSize, BeanFactory beanFactory, ScheduledThreadPoolExecutor delegate) {
        super(corePoolSize);
        this.beanFactory = beanFactory;
        this.delegate = delegate;
        this.decorateTaskRunnable = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"decorateTask", (Class[])new Class[]{Runnable.class, RunnableScheduledFuture.class});
        this.makeAccessibleIfNotNull(this.decorateTaskRunnable);
        this.decorateTaskCallable = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"decorateTaskCallable", (Class[])new Class[]{Callable.class, RunnableScheduledFuture.class});
        this.makeAccessibleIfNotNull(this.decorateTaskCallable);
        this.finalize = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"finalize", null);
        this.makeAccessibleIfNotNull(this.finalize);
        this.beforeExecute = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"beforeExecute", null);
        this.makeAccessibleIfNotNull(this.beforeExecute);
        this.afterExecute = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"afterExecute", null);
        this.makeAccessibleIfNotNull(this.afterExecute);
        this.terminated = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"terminated", null);
        this.makeAccessibleIfNotNull(this.terminated);
        this.newTaskForRunnable = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"newTaskFor", (Class[])new Class[]{Runnable.class, Object.class});
        this.makeAccessibleIfNotNull(this.newTaskForRunnable);
        this.newTaskForCallable = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"newTaskFor", (Class[])new Class[]{Callable.class, Object.class});
        this.makeAccessibleIfNotNull(this.newTaskForCallable);
    }

    private void makeAccessibleIfNotNull(Method method) {
        if (method != null) {
            ReflectionUtils.makeAccessible((Method)method);
        }
    }

    LazyTraceScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, BeanFactory beanFactory, ScheduledThreadPoolExecutor delegate) {
        super(corePoolSize, threadFactory);
        this.beanFactory = beanFactory;
        this.delegate = delegate;
        this.decorateTaskRunnable = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"decorateTask", (Class[])new Class[]{Runnable.class, RunnableScheduledFuture.class});
        this.makeAccessibleIfNotNull(this.decorateTaskRunnable);
        this.decorateTaskCallable = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"decorateTaskCallable", (Class[])new Class[]{Callable.class, RunnableScheduledFuture.class});
        this.makeAccessibleIfNotNull(this.decorateTaskCallable);
        this.finalize = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"finalize");
        this.makeAccessibleIfNotNull(this.finalize);
        this.beforeExecute = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"beforeExecute");
        this.makeAccessibleIfNotNull(this.beforeExecute);
        this.afterExecute = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"afterExecute", null);
        this.makeAccessibleIfNotNull(this.afterExecute);
        this.terminated = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"terminated", null);
        this.makeAccessibleIfNotNull(this.terminated);
        this.newTaskForRunnable = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"newTaskFor", (Class[])new Class[]{Runnable.class, Object.class});
        this.makeAccessibleIfNotNull(this.newTaskForRunnable);
        this.newTaskForCallable = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"newTaskFor", (Class[])new Class[]{Callable.class, Object.class});
        this.makeAccessibleIfNotNull(this.newTaskForCallable);
    }

    LazyTraceScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler, BeanFactory beanFactory, ScheduledThreadPoolExecutor delegate) {
        super(corePoolSize, handler);
        this.beanFactory = beanFactory;
        this.delegate = delegate;
        this.decorateTaskRunnable = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"decorateTask", (Class[])new Class[]{Runnable.class, RunnableScheduledFuture.class});
        this.makeAccessibleIfNotNull(this.decorateTaskRunnable);
        this.decorateTaskCallable = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"decorateTaskCallable", (Class[])new Class[]{Callable.class, RunnableScheduledFuture.class});
        this.makeAccessibleIfNotNull(this.decorateTaskCallable);
        this.finalize = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"finalize", null);
        this.makeAccessibleIfNotNull(this.finalize);
        this.beforeExecute = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"beforeExecute", null);
        this.makeAccessibleIfNotNull(this.beforeExecute);
        this.afterExecute = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"afterExecute", null);
        this.makeAccessibleIfNotNull(this.afterExecute);
        this.terminated = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"terminated", null);
        this.makeAccessibleIfNotNull(this.terminated);
        this.newTaskForRunnable = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"newTaskFor", (Class[])new Class[]{Runnable.class, Object.class});
        this.makeAccessibleIfNotNull(this.newTaskForRunnable);
        this.newTaskForCallable = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"newTaskFor", (Class[])new Class[]{Callable.class, Object.class});
        this.makeAccessibleIfNotNull(this.newTaskForCallable);
    }

    LazyTraceScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler, BeanFactory beanFactory, ScheduledThreadPoolExecutor delegate) {
        super(corePoolSize, threadFactory, handler);
        this.beanFactory = beanFactory;
        this.delegate = delegate;
        this.decorateTaskRunnable = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"decorateTask", (Class[])new Class[]{Runnable.class, RunnableScheduledFuture.class});
        this.makeAccessibleIfNotNull(this.decorateTaskRunnable);
        this.decorateTaskCallable = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"decorateTaskCallable", (Class[])new Class[]{Callable.class, RunnableScheduledFuture.class});
        this.makeAccessibleIfNotNull(this.decorateTaskCallable);
        this.finalize = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"finalize", null);
        this.makeAccessibleIfNotNull(this.finalize);
        this.beforeExecute = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"beforeExecute", null);
        this.makeAccessibleIfNotNull(this.beforeExecute);
        this.afterExecute = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"afterExecute", null);
        this.makeAccessibleIfNotNull(this.afterExecute);
        this.terminated = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"terminated");
        this.makeAccessibleIfNotNull(this.terminated);
        this.newTaskForRunnable = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"newTaskFor", (Class[])new Class[]{Runnable.class, Object.class});
        this.makeAccessibleIfNotNull(this.newTaskForRunnable);
        this.newTaskForCallable = ReflectionUtils.findMethod(ScheduledThreadPoolExecutor.class, (String)"newTaskFor", (Class[])new Class[]{Callable.class, Object.class});
        this.makeAccessibleIfNotNull(this.newTaskForCallable);
    }

    private Runnable traceRunnableWhenContextReady(Runnable delegate) {
        if (ContextUtil.isContextUnusable(this.beanFactory)) {
            return delegate;
        }
        return new TraceRunnable(this.tracing(), this.spanNamer(), delegate);
    }

    private <V> Callable<V> traceCallableWhenContextReady(Callable<V> delegate) {
        if (ContextUtil.isContextUnusable(this.beanFactory)) {
            return delegate;
        }
        return new TraceCallable<V>(this.tracing(), this.spanNamer(), delegate);
    }

    @Override
    public <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        return (RunnableScheduledFuture)ReflectionUtils.invokeMethod((Method)this.decorateTaskRunnable, (Object)this.delegate, (Object[])new Object[]{this.traceRunnableWhenContextReady(runnable), task});
    }

    @Override
    public <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
        return (RunnableScheduledFuture)ReflectionUtils.invokeMethod((Method)this.decorateTaskCallable, (Object)this.delegate, (Object[])new Object[]{this.traceCallableWhenContextReady(callable), task});
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.delegate.schedule(this.traceRunnableWhenContextReady(command), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.delegate.schedule(this.traceCallableWhenContextReady(callable), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.delegate.scheduleAtFixedRate(this.traceRunnableWhenContextReady(command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.delegate.scheduleWithFixedDelay(this.traceRunnableWhenContextReady(command), initialDelay, delay, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(this.traceRunnableWhenContextReady(command));
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(this.traceRunnableWhenContextReady(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(this.traceRunnableWhenContextReady(task), result);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.traceCallableWhenContextReady(task));
    }

    @Override
    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean value) {
        this.delegate.setContinueExistingPeriodicTasksAfterShutdownPolicy(value);
    }

    @Override
    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return this.delegate.getContinueExistingPeriodicTasksAfterShutdownPolicy();
    }

    @Override
    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean value) {
        this.delegate.setExecuteExistingDelayedTasksAfterShutdownPolicy(value);
    }

    @Override
    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return this.delegate.getExecuteExistingDelayedTasksAfterShutdownPolicy();
    }

    @Override
    public void setRemoveOnCancelPolicy(boolean value) {
        this.delegate.setRemoveOnCancelPolicy(value);
    }

    @Override
    public boolean getRemoveOnCancelPolicy() {
        return this.delegate.getRemoveOnCancelPolicy();
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return this.delegate.getQueue();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminating() {
        return this.delegate.isTerminating();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public void finalize() {
    }

    @Override
    public void setThreadFactory(ThreadFactory threadFactory) {
        this.delegate.setThreadFactory(threadFactory);
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.delegate.getThreadFactory();
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        this.delegate.setRejectedExecutionHandler(handler);
    }

    @Override
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.delegate.getRejectedExecutionHandler();
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
        this.delegate.setCorePoolSize(corePoolSize);
    }

    @Override
    public int getCorePoolSize() {
        return this.delegate.getCorePoolSize();
    }

    @Override
    public boolean prestartCoreThread() {
        return this.delegate.prestartCoreThread();
    }

    @Override
    public int prestartAllCoreThreads() {
        return this.delegate.prestartAllCoreThreads();
    }

    @Override
    public boolean allowsCoreThreadTimeOut() {
        return this.delegate.allowsCoreThreadTimeOut();
    }

    @Override
    public void allowCoreThreadTimeOut(boolean value) {
        this.delegate.allowCoreThreadTimeOut(value);
    }

    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        this.delegate.setMaximumPoolSize(maximumPoolSize);
    }

    @Override
    public int getMaximumPoolSize() {
        return this.delegate.getMaximumPoolSize();
    }

    @Override
    public void setKeepAliveTime(long time, TimeUnit unit) {
        this.delegate.setKeepAliveTime(time, unit);
    }

    @Override
    public long getKeepAliveTime(TimeUnit unit) {
        return this.delegate.getKeepAliveTime(unit);
    }

    @Override
    public boolean remove(Runnable task) {
        return this.delegate.remove(task);
    }

    @Override
    public void purge() {
        this.delegate.purge();
    }

    @Override
    public int getPoolSize() {
        return this.delegate.getPoolSize();
    }

    @Override
    public int getActiveCount() {
        return this.delegate.getActiveCount();
    }

    @Override
    public int getLargestPoolSize() {
        return this.delegate.getLargestPoolSize();
    }

    @Override
    public long getTaskCount() {
        return this.delegate.getTaskCount();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.delegate.getCompletedTaskCount();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void beforeExecute(Thread t, Runnable r) {
        ReflectionUtils.invokeMethod((Method)this.beforeExecute, (Object)this.delegate, (Object[])new Object[]{t, this.traceRunnableWhenContextReady(r)});
    }

    @Override
    public void afterExecute(Runnable r, Throwable t) {
        ReflectionUtils.invokeMethod((Method)this.afterExecute, (Object)this.delegate, (Object[])new Object[]{this.traceRunnableWhenContextReady(r), t});
    }

    @Override
    public void terminated() {
        ReflectionUtils.invokeMethod((Method)this.terminated, (Object)this.delegate);
    }

    @Override
    public <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return (RunnableFuture)ReflectionUtils.invokeMethod((Method)this.newTaskForRunnable, (Object)this.delegate, (Object[])new Object[]{this.traceRunnableWhenContextReady(runnable), value});
    }

    @Override
    public <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return (RunnableFuture)ReflectionUtils.invokeMethod((Method)this.newTaskForCallable, (Object)this.delegate, (Object[])new Object[]{this.traceCallableWhenContextReady(callable)});
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.wrapCallableCollection(tasks));
    }

    private <T> Collection<? extends Callable<T>> wrapCallableCollection(Collection<? extends Callable<T>> tasks) {
        ArrayList<Callable<T>> ts = new ArrayList<Callable<T>>();
        for (Callable<T> task : tasks) {
            if (task instanceof TraceCallable) continue;
            ts.add(this.traceCallableWhenContextReady(task));
        }
        return ts;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.wrapCallableCollection(tasks), timeout, unit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapCallableCollection(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapCallableCollection(tasks), timeout, unit);
    }

    private Tracing tracing() {
        if (this.tracing == null) {
            this.tracing = (Tracing)this.beanFactory.getBean(Tracing.class);
        }
        return this.tracing;
    }

    private SpanNamer spanNamer() {
        if (this.spanNamer == null) {
            try {
                this.spanNamer = (SpanNamer)this.beanFactory.getBean(SpanNamer.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                log.warn((Object)"SpanNamer bean not found - will provide a manually created instance");
                return new DefaultSpanNamer();
            }
        }
        return this.spanNamer;
    }
}

