/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.circuitbreaker;

import brave.Tracer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;
import org.springframework.cloud.sleuth.instrument.circuitbreaker.TraceFunction;
import org.springframework.cloud.sleuth.instrument.circuitbreaker.TraceSupplier;

class TraceCircuitBreaker
implements CircuitBreaker {
    private final CircuitBreaker delegate;
    private final Tracer tracer;

    TraceCircuitBreaker(CircuitBreaker delegate, Tracer tracer) {
        this.delegate = delegate;
        this.tracer = tracer;
    }

    public <T> T run(Supplier<T> toRun, Function<Throwable, T> fallback) {
        return (T)this.delegate.run(new TraceSupplier<T>(this.tracer, toRun), new TraceFunction<T>(this.tracer, fallback));
    }

    public <T> T run(Supplier<T> toRun) {
        return (T)this.delegate.run(new TraceSupplier<T>(this.tracer, toRun));
    }
}

