/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.redis;

import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.tracing.Tracing;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.redis.LazyTracing;

class TraceLettuceClientResourcesBeanPostProcessor
implements BeanPostProcessor {
    private static final Log log = LogFactory.getLog(TraceLettuceClientResourcesBeanPostProcessor.class);
    private final BeanFactory beanFactory;

    TraceLettuceClientResourcesBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ClientResources) {
            ClientResources cr = (ClientResources)bean;
            if (!cr.tracing().isEnabled()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Lettuce ClientResources bean is auto-configured to enable tracing.");
                }
                return cr.mutate().tracing((Tracing)new LazyTracing(this.beanFactory)).build();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Lettuce ClientResources bean is skipped for auto-configuration because tracing was already enabled.");
            }
        }
        return bean;
    }
}

