/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.Span;
import brave.propagation.CurrentTraceContext;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.TraceWebFilter;
import org.springframework.web.reactive.HandlerAdapter;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.support.HandlerFunctionAdapter;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

class TraceHandlerFunctionAdapterBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;

    TraceHandlerFunctionAdapterBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof HandlerFunctionAdapter) {
            return new TraceHandlerAdapter((HandlerAdapter)bean, this.beanFactory);
        }
        return bean;
    }

    private static final class TraceHandlerFunction
    implements HandlerFunction {
        private final HandlerFunction<?> delegate;
        private final BeanFactory beanFactory;
        private CurrentTraceContext currentTraceContext;

        private TraceHandlerFunction(HandlerFunction<?> delegate, BeanFactory beanFactory) {
            this.delegate = delegate;
            this.beanFactory = beanFactory;
        }

        public Mono<?> handle(ServerRequest serverRequest) {
            AtomicReference scope = new AtomicReference();
            return Mono.just(scope).doFirst(() -> serverRequest.attribute(TraceWebFilter.TRACE_REQUEST_ATTR).ifPresent(span -> scope.set(this.currentTraceContext().maybeScope(((Span)span).context())))).flatMap(r -> this.delegate.handle(serverRequest)).doFinally(signalType -> {
                CurrentTraceContext.Scope spanInScope = (CurrentTraceContext.Scope)scope.get();
                if (spanInScope != null) {
                    spanInScope.close();
                }
            });
        }

        private CurrentTraceContext currentTraceContext() {
            if (this.currentTraceContext == null) {
                this.currentTraceContext = (CurrentTraceContext)this.beanFactory.getBean(CurrentTraceContext.class);
            }
            return this.currentTraceContext;
        }
    }

    private static final class TraceHandlerAdapter
    implements HandlerAdapter {
        private final BeanFactory beanFactory;
        private final HandlerAdapter delegate;

        private TraceHandlerAdapter(HandlerAdapter delegate, BeanFactory beanFactory) {
            this.delegate = delegate;
            this.beanFactory = beanFactory;
        }

        public boolean supports(Object handler) {
            return this.delegate.supports(handler);
        }

        public Mono<HandlerResult> handle(ServerWebExchange exchange, Object handler) {
            HandlerFunction handlerFunction = (HandlerFunction)handler;
            TraceHandlerFunction traceHandlerFunction = new TraceHandlerFunction(handlerFunction, this.beanFactory);
            return this.delegate.handle(exchange, (Object)traceHandlerFunction);
        }
    }
}

