/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.Tracing;
import brave.http.HttpTracing;
import brave.servlet.TracingFilter;
import brave.spring.webmvc.SpanCustomizingAsyncHandlerInterceptor;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.instrument.web.ExceptionLoggingFilter;
import org.springframework.cloud.sleuth.instrument.web.LazyTracingFilter;
import org.springframework.cloud.sleuth.instrument.web.SleuthWebProperties;
import org.springframework.cloud.sleuth.instrument.web.TraceHttpAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.TraceWebAspect;
import org.springframework.cloud.sleuth.instrument.web.TraceWebMvcConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Deprecated
@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.web.enabled"}, matchIfMissing=true)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnBean(value={HttpTracing.class})
@AutoConfigureAfter(value={TraceHttpAutoConfiguration.class})
@ConditionalOnClass(value={HandlerInterceptorAdapter.class})
@Import(value={SpanCustomizingAsyncHandlerInterceptor.class})
public class TraceWebServletAutoConfiguration {
    public static final int TRACING_FILTER_ORDER = -2147483643;

    @Bean
    TraceWebAspect traceWebAspect(Tracing tracing, SpanNamer spanNamer) {
        return new TraceWebAspect(tracing, spanNamer);
    }

    @Bean
    public FilterRegistrationBean traceWebFilter(BeanFactory beanFactory, SleuthWebProperties webProperties) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new LazyTracingFilter(beanFactory), new ServletRegistrationBean[0]);
        filterRegistrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST});
        filterRegistrationBean.setOrder(webProperties.getFilterOrder());
        return filterRegistrationBean;
    }

    @Bean
    @ConditionalOnProperty(value={"spring.sleuth.web.exception-logging-filter-enabled"})
    public FilterRegistrationBean exceptionThrowingFilter(SleuthWebProperties webProperties) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new ExceptionLoggingFilter(), new ServletRegistrationBean[0]);
        filterRegistrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST});
        filterRegistrationBean.setOrder(webProperties.getFilterOrder());
        return filterRegistrationBean;
    }

    @Bean
    @ConditionalOnMissingBean
    public TracingFilter tracingFilter(HttpTracing tracing) {
        return (TracingFilter)TracingFilter.create((HttpTracing)tracing);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={WebMvcConfigurer.class})
    @Import(value={TraceWebMvcConfigurer.class})
    protected static class TraceWebMvcAutoConfiguration {
        protected TraceWebMvcAutoConfiguration() {
        }
    }
}

