/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import brave.Span;
import brave.Tracer;
import brave.http.HttpTracing;
import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.loadbalancer.RetryableFeignBlockingLoadBalancerClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TracingFeignClient;

class TraceRetryableFeignBlockingLoadBalancerClient
extends RetryableFeignBlockingLoadBalancerClient {
    private static final Log LOG = LogFactory.getLog(TraceRetryableFeignBlockingLoadBalancerClient.class);
    private final BeanFactory beanFactory;
    Tracer tracer;
    HttpTracing httpTracing;
    TracingFeignClient tracingFeignClient;

    TraceRetryableFeignBlockingLoadBalancerClient(Client delegate, BlockingLoadBalancerClient loadBalancerClient, LoadBalancedRetryFactory retryFactory, BeanFactory beanFactory) {
        super(delegate, loadBalancerClient, retryFactory);
        this.beanFactory = beanFactory;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Before send");
        }
        Response response = null;
        Span fallbackSpan = this.tracer().nextSpan().start();
        try {
            response = super.execute(request, options);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"After receive");
            }
            Response response2 = response;
            return response2;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Exception thrown", (Throwable)e);
            }
            if (e instanceof IOException) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"IO exception was thrown, so most likely the traced client wasn't called. Falling back to a manual span");
                }
                this.tracingFeignClient().handleSendAndReceive(fallbackSpan, request, response, e);
            }
            throw e;
        }
        finally {
            fallbackSpan.abandon();
        }
    }

    private Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    private HttpTracing httpTracing() {
        if (this.httpTracing == null) {
            this.httpTracing = (HttpTracing)this.beanFactory.getBean(HttpTracing.class);
        }
        return this.httpTracing;
    }

    private TracingFeignClient tracingFeignClient() {
        if (this.tracingFeignClient == null) {
            this.tracingFeignClient = (TracingFeignClient)TracingFeignClient.create(this.httpTracing(), this.getDelegate());
        }
        return this.tracingFeignClient;
    }
}

