/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.messaging.support.NativeMessageHeaderAccessor;
import org.springframework.util.StringUtils;

public class MessageHeaderPropagatorGetter
implements Propagator.Getter<MessageHeaderAccessor> {
    private static final Log log = LogFactory.getLog(MessageHeaderPropagatorGetter.class);

    public String get(MessageHeaderAccessor accessor, String key) {
        block3: {
            try {
                String value = this.doGet(accessor, key);
                if (StringUtils.hasText((String)value)) {
                    return value;
                }
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("An exception happened when we tried to retrieve the [" + key + "] from message"), (Throwable)ex);
            }
        }
        return null;
    }

    private String doGet(MessageHeaderAccessor accessor, String key) {
        Object result;
        if (accessor instanceof NativeMessageHeaderAccessor) {
            NativeMessageHeaderAccessor nativeAccessor = (NativeMessageHeaderAccessor)accessor;
            String result2 = nativeAccessor.getFirstNativeHeader(key);
            if (result2 != null) {
                return result2;
            }
        } else {
            Object result3;
            Object nativeHeaders = accessor.getHeader("nativeHeaders");
            if (nativeHeaders instanceof Map && (result3 = ((Map)nativeHeaders).get(key)) instanceof List && !((List)result3).isEmpty()) {
                return String.valueOf(((List)result3).get(0));
            }
        }
        if ((result = accessor.getHeader(key)) != null) {
            if (result instanceof byte[]) {
                return new String((byte[])result, StandardCharsets.UTF_8);
            }
            return result.toString();
        }
        return null;
    }

    public String toString() {
        return "MessageHeaderPropagatorGetter{}";
    }
}

