/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.internal.SpanNameUtil;
import org.springframework.util.ReflectionUtils;

@Aspect
public class TraceAsyncAspect {
    private static final String CLASS_KEY = "class";
    private static final String METHOD_KEY = "method";
    private final Tracer tracer;
    private final SpanNamer spanNamer;

    public TraceAsyncAspect(Tracer tracer, SpanNamer spanNamer) {
        this.tracer = tracer;
        this.spanNamer = spanNamer;
    }

    /*
     * Loose catch block
     */
    @Around(value="execution (@org.springframework.scheduling.annotation.Async  * *.*(..))")
    public Object traceBackgroundThread(ProceedingJoinPoint pjp) throws Throwable {
        String spanName = this.name(pjp);
        Span span = this.tracer.currentSpan();
        if (span == null) {
            span = this.tracer.nextSpan();
        }
        span = span.name(spanName);
        try {
            try (Tracer.SpanInScope ws = this.tracer.withSpan(span.start());){
                span.tag(CLASS_KEY, pjp.getTarget().getClass().getSimpleName());
                span.tag(METHOD_KEY, pjp.getSignature().getName());
                Object object = pjp.proceed();
                return object;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            span.end();
        }
    }

    String name(ProceedingJoinPoint pjp) {
        return this.spanNamer.name((Object)this.getMethod(pjp, pjp.getTarget()), SpanNameUtil.toLowerHyphen(pjp.getSignature().getName()));
    }

    private Method getMethod(ProceedingJoinPoint pjp, Object object) {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        return ReflectionUtils.findMethod(object.getClass(), (String)method.getName(), (Class[])method.getParameterTypes());
    }
}

