/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.kafka;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.docs.AssertingSpanBuilder;
import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.docs.TagKey;
import org.springframework.cloud.sleuth.instrument.kafka.SleuthKafkaSpan;
import org.springframework.cloud.sleuth.propagation.Propagator;

final class KafkaTracingUtils {
    private static final Log log = LogFactory.getLog(KafkaTracingUtils.class);

    private KafkaTracingUtils() {
    }

    static <K, V> void buildAndFinishSpan(ConsumerRecord<K, V> consumerRecord, Propagator propagator, Propagator.Getter<ConsumerRecord<?, ?>> extractor) {
        AssertingSpanBuilder spanBuilder = AssertingSpanBuilder.of((DocumentedSpan)SleuthKafkaSpan.KAFKA_CONSUMER_SPAN, (Span.Builder)propagator.extract(consumerRecord, extractor).kind(Span.Kind.CONSUMER)).name(SleuthKafkaSpan.KAFKA_CONSUMER_SPAN.getName()).tag((TagKey)SleuthKafkaSpan.ConsumerTags.TOPIC, consumerRecord.topic()).tag((TagKey)SleuthKafkaSpan.ConsumerTags.OFFSET, Long.toString(consumerRecord.offset())).tag((TagKey)SleuthKafkaSpan.ConsumerTags.PARTITION, Integer.toString(consumerRecord.partition()));
        Span span = spanBuilder.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracted span from event headers " + span));
        }
        span.end();
    }
}

