/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignObjectWrapper;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TracingFeignClient;

class LazyClient
implements Client {
    private final BeanFactory beanFactory;
    private Client delegate;
    private TraceFeignObjectWrapper wrapper;

    LazyClient(BeanFactory beanFactory, Client client) {
        this.beanFactory = beanFactory;
        this.delegate = client;
    }

    LazyClient(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        return ((Client)this.wrapper().wrap(this.delegate())).execute(request, options);
    }

    private Client delegate() {
        if (this.delegate == null) {
            try {
                this.delegate = (Client)this.beanFactory.getBean(Client.class);
            }
            catch (BeansException ex) {
                this.delegate = TracingFeignClient.create((CurrentTraceContext)this.beanFactory.getBean(CurrentTraceContext.class), (HttpClientHandler)this.beanFactory.getBean(HttpClientHandler.class), (Client)new Client.Default(null, null));
            }
        }
        return this.delegate;
    }

    private TraceFeignObjectWrapper wrapper() {
        if (this.wrapper == null) {
            this.wrapper = new TraceFeignObjectWrapper(this.beanFactory);
        }
        return this.wrapper;
    }
}

