/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.batch;

import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.batch.TraceStepExecutionListener;

public class TraceStepBuilderFactory
extends StepBuilderFactory {
    private final BeanFactory beanFactory;
    private final StepBuilderFactory delegate;
    private Tracer tracer;

    public TraceStepBuilderFactory(BeanFactory beanFactory, StepBuilderFactory delegate) {
        super(null, null);
        this.beanFactory = beanFactory;
        this.delegate = delegate;
    }

    public StepBuilder get(String name) {
        return (StepBuilder)this.delegate.get(name).listener((StepExecutionListener)new TraceStepExecutionListener(this.tracer()));
    }

    private Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }
}

