/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.TraceCallable;
import org.springframework.cloud.sleuth.instrument.async.TraceRunnable;
import org.springframework.cloud.sleuth.internal.ContextUtil;
import org.springframework.cloud.sleuth.internal.DefaultSpanNamer;
import org.springframework.core.task.TaskDecorator;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;

public class LazyTraceThreadPoolTaskExecutor
extends ThreadPoolTaskExecutor {
    private static final Log log = LogFactory.getLog(LazyTraceThreadPoolTaskExecutor.class);
    private static final Map<ThreadPoolTaskExecutor, LazyTraceThreadPoolTaskExecutor> CACHE = new ConcurrentHashMap<ThreadPoolTaskExecutor, LazyTraceThreadPoolTaskExecutor>();
    private final BeanFactory beanFactory;
    private final ThreadPoolTaskExecutor delegate;
    private final String beanName;
    private Tracer tracer;
    private SpanNamer spanNamer;

    public LazyTraceThreadPoolTaskExecutor(BeanFactory beanFactory, ThreadPoolTaskExecutor delegate) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
        this.beanName = null;
    }

    public LazyTraceThreadPoolTaskExecutor(BeanFactory beanFactory, ThreadPoolTaskExecutor delegate, String beanName) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
        this.beanName = beanName;
    }

    public static LazyTraceThreadPoolTaskExecutor wrap(BeanFactory beanFactory, @NonNull ThreadPoolTaskExecutor delegate, String beanName) {
        return CACHE.computeIfAbsent(delegate, e -> new LazyTraceThreadPoolTaskExecutor(beanFactory, delegate, beanName));
    }

    public static LazyTraceThreadPoolTaskExecutor wrap(BeanFactory beanFactory, @NonNull ThreadPoolTaskExecutor delegate) {
        return CACHE.computeIfAbsent(delegate, e -> new LazyTraceThreadPoolTaskExecutor(beanFactory, delegate, null));
    }

    public void execute(Runnable task) {
        this.delegate.execute(this.wrap(task));
    }

    public void execute(Runnable task, long startTimeout) {
        this.delegate.execute(this.wrap(task), startTimeout);
    }

    public Future<?> submit(Runnable task) {
        return this.delegate.submit(this.wrap(task));
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.wrap(task));
    }

    public ListenableFuture<?> submitListenable(Runnable task) {
        return this.delegate.submitListenable(this.wrap(task));
    }

    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        return this.delegate.submitListenable(this.wrap(task));
    }

    public boolean prefersShortLivedTasks() {
        return this.delegate.prefersShortLivedTasks();
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.delegate.setThreadFactory(threadFactory);
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.delegate.setRejectedExecutionHandler(rejectedExecutionHandler);
    }

    public void setWaitForTasksToCompleteOnShutdown(boolean waitForJobsToCompleteOnShutdown) {
        this.delegate.setWaitForTasksToCompleteOnShutdown(waitForJobsToCompleteOnShutdown);
    }

    public void setAwaitTerminationSeconds(int awaitTerminationSeconds) {
        this.delegate.setAwaitTerminationSeconds(awaitTerminationSeconds);
    }

    public void setBeanName(String name) {
        this.delegate.setBeanName(name);
    }

    public ThreadPoolExecutor getThreadPoolExecutor() throws IllegalStateException {
        return this.delegate.getThreadPoolExecutor();
    }

    public int getPoolSize() {
        return this.delegate.getPoolSize();
    }

    public int getActiveCount() {
        return this.delegate.getActiveCount();
    }

    public void destroy() {
        this.delegate.destroy();
        super.destroy();
    }

    public void afterPropertiesSet() {
        this.delegate.afterPropertiesSet();
        super.afterPropertiesSet();
    }

    public void initialize() {
        this.delegate.initialize();
    }

    public void shutdown() {
        this.delegate.shutdown();
        super.shutdown();
    }

    public Thread newThread(Runnable runnable) {
        return this.delegate.newThread(this.wrap(runnable));
    }

    private Runnable wrap(Runnable runnable) {
        if (runnable instanceof TraceRunnable) {
            return runnable;
        }
        return ContextUtil.isContextUnusable(this.beanFactory) ? runnable : new TraceRunnable(this.tracer(), this.spanNamer(), runnable, this.beanName);
    }

    private <V> Callable<V> wrap(Callable<V> callable) {
        if (callable instanceof TraceCallable) {
            return callable;
        }
        return ContextUtil.isContextUnusable(this.beanFactory) ? callable : new TraceCallable(this.tracer(), this.spanNamer(), callable, this.beanName);
    }

    public String getThreadNamePrefix() {
        return this.delegate.getThreadNamePrefix();
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.delegate.setThreadNamePrefix(threadNamePrefix);
    }

    public int getThreadPriority() {
        return this.delegate.getThreadPriority();
    }

    public void setThreadPriority(int threadPriority) {
        this.delegate.setThreadPriority(threadPriority);
    }

    public boolean isDaemon() {
        return this.delegate.isDaemon();
    }

    public void setDaemon(boolean daemon) {
        this.delegate.setDaemon(daemon);
    }

    public void setThreadGroupName(String name) {
        this.delegate.setThreadGroupName(name);
    }

    public ThreadGroup getThreadGroup() {
        return this.delegate.getThreadGroup();
    }

    public void setThreadGroup(ThreadGroup threadGroup) {
        this.delegate.setThreadGroup(threadGroup);
    }

    public Thread createThread(Runnable runnable) {
        return this.delegate.createThread(this.wrap(runnable));
    }

    public int getCorePoolSize() {
        return this.delegate.getCorePoolSize();
    }

    public void setCorePoolSize(int corePoolSize) {
        this.delegate.setCorePoolSize(corePoolSize);
    }

    public int getMaxPoolSize() {
        return this.delegate.getMaxPoolSize();
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.delegate.setMaxPoolSize(maxPoolSize);
    }

    public int getKeepAliveSeconds() {
        return this.delegate.getKeepAliveSeconds();
    }

    public void setKeepAliveSeconds(int keepAliveSeconds) {
        this.delegate.setKeepAliveSeconds(keepAliveSeconds);
    }

    public void setQueueCapacity(int queueCapacity) {
        this.delegate.setQueueCapacity(queueCapacity);
    }

    public void setAllowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.delegate.setAllowCoreThreadTimeOut(allowCoreThreadTimeOut);
    }

    public void setTaskDecorator(TaskDecorator taskDecorator) {
        this.delegate.setTaskDecorator(taskDecorator);
    }

    private Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    private SpanNamer spanNamer() {
        if (this.spanNamer == null) {
            try {
                this.spanNamer = (SpanNamer)this.beanFactory.getBean(SpanNamer.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                log.warn((Object)"SpanNamer bean not found - will provide a manually created instance");
                return new DefaultSpanNamer();
            }
        }
        return this.spanNamer;
    }
}

