/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.mongodb;

import com.mongodb.MongoSocketException;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.event.CommandStartedEvent;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.instrument.mongodb.TraceMongoClusterIdSpanCustomizer;
import org.springframework.cloud.sleuth.instrument.mongodb.TraceMongoSpanCustomizer;

public class TraceMongoSocketAddressSpanCustomizer
implements TraceMongoSpanCustomizer {
    private static final Log log = LogFactory.getLog(TraceMongoClusterIdSpanCustomizer.class);

    @Override
    public void customizeCommandStartSpan(CommandStartedEvent event, Span.Builder spanBuilder) {
        block3: {
            ConnectionDescription connectionDescription = event.getConnectionDescription();
            if (connectionDescription != null) {
                try {
                    InetSocketAddress socketAddress = connectionDescription.getServerAddress().getSocketAddress();
                    spanBuilder.remoteIpAndPort(socketAddress.getAddress().getHostAddress(), socketAddress.getPort());
                }
                catch (MongoSocketException ignored) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"Ignored exception when setting remote ip and port", (Throwable)ignored);
                }
            }
        }
    }
}

