/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.tx;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanAndScope;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.instrument.tx.SleuthTxSpan;
import org.springframework.cloud.sleuth.instrument.tx.TracePlatformTransactionManagerTags;
import org.springframework.transaction.ReactiveTransaction;
import org.springframework.transaction.ReactiveTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class TraceReactiveTransactionManager
implements ReactiveTransactionManager {
    private static final Log log = LogFactory.getLog(TraceReactiveTransactionManager.class);
    private final ReactiveTransactionManager delegate;
    private final BeanFactory beanFactory;
    private Tracer tracer;
    private CurrentTraceContext currentTraceContext;

    public TraceReactiveTransactionManager(ReactiveTransactionManager delegate, BeanFactory beanFactory) {
        this.delegate = delegate;
        this.beanFactory = beanFactory;
    }

    private Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    private CurrentTraceContext currentTraceContext() {
        if (this.currentTraceContext == null) {
            this.currentTraceContext = (CurrentTraceContext)this.beanFactory.getBean(CurrentTraceContext.class);
        }
        return this.currentTraceContext;
    }

    public Mono<ReactiveTransaction> getReactiveTransaction(TransactionDefinition definition) throws TransactionException {
        return Mono.deferContextual(contextView -> this.delegate.getReactiveTransaction(definition).map(tx -> {
            AssertingSpan span = AssertingSpan.continueSpan((DocumentedSpan)SleuthTxSpan.TX_SPAN, (Span)SleuthTxSpan.TX_SPAN.wrap(this.span((ContextView)contextView)));
            if (tx.isNewTransaction() || span == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("New transaction is required, span in context [" + span + "]"));
                }
                span = span == null ? SleuthTxSpan.TX_SPAN.wrap(this.tracer().nextSpan()).name(SleuthTxSpan.TX_SPAN.getName()).start() : SleuthTxSpan.TX_SPAN.wrap(this.tracer().nextSpan((Span)span)).name(SleuthTxSpan.TX_SPAN.getName()).start();
                TracePlatformTransactionManagerTags.tag((Span)span, definition, this.delegate.getClass());
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Will continue the transaction for span [" + span + "]"));
            }
            Tracer.SpanInScope withSpan = this.tracer().withSpan((Span)span);
            SpanAndScope spanAndScope = new SpanAndScope((Span)span, withSpan);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Got transaction for span [" + spanAndScope + "]"));
            }
            return new TraceReactiveTransaction((ReactiveTransaction)tx, spanAndScope);
        }));
    }

    private Span span(ContextView contextView) {
        Span span = (Span)contextView.getOrDefault(Span.class, null);
        if (span == null) {
            TraceContext traceContext = (TraceContext)contextView.getOrDefault(TraceContext.class, null);
            if (traceContext == null) {
                Span currentSpan = this.tracer().currentSpan();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("There's no Span or TraceContext in the reactor context. Current span is [" + currentSpan + "]"));
                }
                span = currentSpan;
            } else {
                span = this.spanFromContext(traceContext);
            }
        }
        return span;
    }

    private Span spanFromContext(TraceContext traceContext) {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext().maybeScope(traceContext);){
            AssertingSpan assertingSpan = SleuthTxSpan.TX_SPAN.wrap(this.tracer().currentSpan()).start();
            return assertingSpan;
        }
    }

    public Mono<Void> commit(ReactiveTransaction transaction) throws TransactionException {
        if (!(transaction instanceof TraceReactiveTransaction)) {
            return this.delegate.commit(transaction);
        }
        TraceReactiveTransaction reactiveTransaction = (TraceReactiveTransaction)transaction;
        SpanAndScope spanAndScope = reactiveTransaction.spanAndScope;
        Span span = spanAndScope.getSpan();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Committing the transaction for span [" + spanAndScope + "]"));
        }
        spanAndScope.getScope().close();
        return this.delegate.commit(reactiveTransaction.delegate).doOnError(arg_0 -> ((Span)span).error(arg_0)).doOnSuccess(signalType -> spanAndScope.close());
    }

    public Mono<Void> rollback(ReactiveTransaction transaction) throws TransactionException {
        if (!(transaction instanceof TraceReactiveTransaction)) {
            return this.delegate.rollback(transaction);
        }
        TraceReactiveTransaction reactiveTransaction = (TraceReactiveTransaction)transaction;
        SpanAndScope spanAndScope = reactiveTransaction.spanAndScope;
        Span span = spanAndScope.getSpan();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Rolling back the transaction for span [" + spanAndScope + "]"));
        }
        spanAndScope.getScope().close();
        return this.delegate.rollback(reactiveTransaction.delegate).doOnError(arg_0 -> ((Span)span).error(arg_0)).doFinally(signalType -> spanAndScope.close());
    }

    static class TraceReactiveTransaction
    implements ReactiveTransaction {
        final ReactiveTransaction delegate;
        final SpanAndScope spanAndScope;

        TraceReactiveTransaction(ReactiveTransaction delegate, SpanAndScope spanAndScope) {
            this.delegate = delegate;
            this.spanAndScope = spanAndScope;
        }

        public boolean isNewTransaction() {
            return this.delegate.isNewTransaction();
        }

        public void setRollbackOnly() {
            this.delegate.setRollbackOnly();
        }

        public boolean isRollbackOnly() {
            return this.delegate.isRollbackOnly();
        }

        public boolean isCompleted() {
            return this.delegate.isCompleted();
        }
    }
}

