/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.lang.reflect.Field;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.web.client.RestTemplateInterceptorInjector;
import org.springframework.cloud.sleuth.instrument.web.mvc.TracingClientHttpRequestInterceptor;
import org.springframework.security.oauth2.client.userinfo.DefaultOAuth2UserService;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class TraceDefaultOAuth2UserServiceCustomizer {
    private static final Log log = LogFactory.getLog(TraceDefaultOAuth2UserServiceCustomizer.class);
    private final BeanFactory beanFactory;
    private static final Field REST_OPERATIONS = ReflectionUtils.findField(DefaultOAuth2UserService.class, (String)"restOperations", RestOperations.class);

    public TraceDefaultOAuth2UserServiceCustomizer(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void customize(DefaultOAuth2UserService service) {
        try {
            ReflectionUtils.makeAccessible((Field)Objects.requireNonNull(REST_OPERATIONS, "restOperations field was not found in [DefaultOAuth2UserService] class"));
            RestOperations restOperations = (RestOperations)REST_OPERATIONS.get(service);
            if (!(restOperations instanceof RestTemplate)) {
                log.warn((Object)"Won't instrument the restOperations field in [DefaultOAuth2UserService] class because it's not a RestTemplate object");
                return;
            }
            RestTemplate template = (RestTemplate)restOperations;
            TracingClientHttpRequestInterceptor interceptor = (TracingClientHttpRequestInterceptor)this.beanFactory.getBean(TracingClientHttpRequestInterceptor.class);
            new RestTemplateInterceptorInjector(interceptor).inject(template);
        }
        catch (Exception e) {
            log.warn((Object)"Can't access the restOperations field - won't instrument the [DefaultOAuth2UserService] class", (Throwable)e);
        }
    }
}

