/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.LinkedList;
import java.util.List;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.otel.bridge.OtelSpan;
import org.springframework.cloud.sleuth.otel.bridge.OtelTraceContext;
import org.springframework.util.StringUtils;

class OtelSpanBuilder
implements Span.Builder {
    static final String REMOTE_SERVICE_NAME_KEY = "peer.service";
    private final SpanBuilder delegate;
    private final List<String> annotations = new LinkedList<String>();
    private String name;
    private Throwable error;

    OtelSpanBuilder(SpanBuilder delegate) {
        this.delegate = delegate;
    }

    static Span.Builder fromOtel(SpanBuilder builder) {
        return new OtelSpanBuilder(builder);
    }

    public Span.Builder setParent(TraceContext context) {
        this.delegate.setParent(OtelTraceContext.toOtelContext(context));
        return this;
    }

    public Span.Builder setNoParent() {
        this.delegate.setNoParent();
        return this;
    }

    public Span.Builder name(String name) {
        this.name = name;
        return this;
    }

    public Span.Builder event(String value) {
        this.annotations.add(value);
        return this;
    }

    public Span.Builder tag(String key, String value) {
        this.delegate.setAttribute(key, value);
        return this;
    }

    public Span.Builder error(Throwable throwable) {
        this.error = throwable;
        return this;
    }

    public Span.Builder kind(Span.Kind spanKind) {
        if (spanKind == null) {
            this.delegate.setSpanKind(SpanKind.INTERNAL);
            return this;
        }
        SpanKind kind = SpanKind.INTERNAL;
        switch (spanKind) {
            case CLIENT: {
                kind = SpanKind.CLIENT;
                break;
            }
            case SERVER: {
                kind = SpanKind.SERVER;
                break;
            }
            case PRODUCER: {
                kind = SpanKind.PRODUCER;
                break;
            }
            case CONSUMER: {
                kind = SpanKind.CONSUMER;
            }
        }
        this.delegate.setSpanKind(kind);
        return this;
    }

    public Span.Builder remoteServiceName(String remoteServiceName) {
        this.delegate.setAttribute(REMOTE_SERVICE_NAME_KEY, remoteServiceName);
        return this;
    }

    public Span.Builder remoteIpAndPort(String ip, int port) {
        this.delegate.setAttribute(SemanticAttributes.NET_PEER_IP, (Object)ip);
        this.delegate.setAttribute(SemanticAttributes.NET_PEER_PORT, (Object)port);
        return this;
    }

    public Span start() {
        io.opentelemetry.api.trace.Span span = this.delegate.startSpan();
        if (StringUtils.hasText((String)this.name)) {
            span.updateName(this.name);
        }
        if (this.error != null) {
            span.recordException(this.error);
        }
        this.annotations.forEach(arg_0 -> ((io.opentelemetry.api.trace.Span)span).addEvent(arg_0));
        return OtelSpan.fromOtel(span);
    }
}

