/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import java.net.URI;
import org.springframework.cloud.sleuth.http.HttpServerRequest;

class HttpRequestNetServerAttributesGetter
implements NetServerAttributesGetter<HttpServerRequest> {
    HttpRequestNetServerAttributesGetter() {
    }

    public String transport(HttpServerRequest httpRequest) {
        String url = httpRequest.url();
        if (url == null) {
            return null;
        }
        URI uri = URI.create(url);
        return uri.getScheme();
    }

    public String hostName(HttpServerRequest httpRequest) {
        String url = httpRequest.url();
        if (url == null) {
            return null;
        }
        URI uri = URI.create(url);
        return uri.getHost();
    }

    public Integer hostPort(HttpServerRequest httpRequest) {
        return httpRequest.remotePort();
    }

    public String sockPeerAddr(HttpServerRequest httpRequest) {
        return httpRequest.remoteIp();
    }

    public Integer sockPeerPort(HttpServerRequest httpRequest) {
        return httpRequest.remotePort();
    }
}

