/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.cloud.sleuth.BaggageInScope;
import org.springframework.cloud.sleuth.BaggageManager;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.ScopedSpan;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanCustomizer;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.otel.bridge.EventPublishingContextWrapper;
import org.springframework.cloud.sleuth.otel.bridge.OtelCurrentTraceContext;
import org.springframework.cloud.sleuth.otel.bridge.OtelScopedSpan;
import org.springframework.cloud.sleuth.otel.bridge.OtelSpan;
import org.springframework.cloud.sleuth.otel.bridge.OtelSpanBuilder;
import org.springframework.cloud.sleuth.otel.bridge.OtelSpanCustomizer;
import org.springframework.cloud.sleuth.otel.bridge.OtelSpanInScope;
import org.springframework.cloud.sleuth.otel.bridge.OtelTraceContext;
import org.springframework.cloud.sleuth.otel.bridge.OtelTraceContextBuilder;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class OtelTracer
implements Tracer {
    private final OtelCurrentTraceContext otelCurrentTraceContext = new OtelCurrentTraceContext();
    private final io.opentelemetry.api.trace.Tracer tracer;
    private final BaggageManager otelBaggageManager;
    private final ApplicationEventPublisher publisher;

    public OtelTracer(io.opentelemetry.api.trace.Tracer tracer, ApplicationEventPublisher publisher, BaggageManager otelBaggageManager) {
        this.tracer = tracer;
        this.publisher = publisher;
        this.otelBaggageManager = otelBaggageManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Span nextSpan(Span parent) {
        if (parent == null) {
            return this.nextSpan();
        }
        OtelSpan otelSpan = OtelTracer.getOtelSpan(parent);
        AtomicReference<Context> context = otelSpan.context().context;
        Context otelContext = context.get();
        Scope scope = null;
        if (otelContext != null) {
            scope = otelContext.makeCurrent();
        }
        try {
            Span span = OtelSpan.fromOtel(this.tracer.spanBuilder("").setParent(OtelTraceContext.toOtelContext(parent.context())).startSpan());
            return span;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }

    private static OtelSpan getOtelSpan(Span parent) {
        if (parent instanceof AssertingSpan) {
            return (OtelSpan)AssertingSpan.unwrap((Span)parent);
        }
        return (OtelSpan)parent;
    }

    public Tracer.SpanInScope withSpan(Span span) {
        io.opentelemetry.api.trace.Span delegate = this.delegate(span);
        return new OtelSpanInScope((OtelSpan)AssertingSpan.unwrap((Span)span), delegate);
    }

    private io.opentelemetry.api.trace.Span delegate(Span span) {
        if (span == null) {
            this.publisher.publishEvent((ApplicationEvent)new EventPublishingContextWrapper.ScopeClosedEvent(this));
            return io.opentelemetry.api.trace.Span.getInvalid();
        }
        return ((OtelSpan)AssertingSpan.unwrap((Span)span)).delegate;
    }

    public SpanCustomizer currentSpanCustomizer() {
        return new OtelSpanCustomizer();
    }

    public Span currentSpan() {
        io.opentelemetry.api.trace.Span currentSpan = io.opentelemetry.api.trace.Span.current();
        if (currentSpan == null || currentSpan.equals(io.opentelemetry.api.trace.Span.getInvalid())) {
            return null;
        }
        return new OtelSpan(currentSpan);
    }

    public Span nextSpan() {
        return new OtelSpan(this.tracer.spanBuilder("").startSpan());
    }

    public ScopedSpan startScopedSpan(String name) {
        io.opentelemetry.api.trace.Span span = this.tracer.spanBuilder(name).startSpan();
        return new OtelScopedSpan(span, span.makeCurrent());
    }

    public Span.Builder spanBuilder() {
        return new OtelSpanBuilder(this.tracer.spanBuilder(""));
    }

    public TraceContext.Builder traceContextBuilder() {
        return new OtelTraceContextBuilder();
    }

    public Map<String, String> getAllBaggage() {
        return this.otelBaggageManager.getAllBaggage();
    }

    public BaggageInScope getBaggage(String name) {
        return this.otelBaggageManager.getBaggage(name);
    }

    public BaggageInScope getBaggage(TraceContext traceContext, String name) {
        return this.otelBaggageManager.getBaggage(traceContext, name);
    }

    public BaggageInScope createBaggage(String name) {
        return this.otelBaggageManager.createBaggage(name);
    }

    public BaggageInScope createBaggage(String name, String value) {
        return this.otelBaggageManager.createBaggage(name, value);
    }

    public CurrentTraceContext currentTraceContext() {
        return this.otelCurrentTraceContext;
    }
}

