/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.propagation;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.baggage.BaggageEntryMetadata;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.BaggageManager;

public class BaggageTextMapPropagator
implements TextMapPropagator {
    private static final String PROPAGATION_UNLIMITED = "propagation=unlimited";
    private static final Log log = LogFactory.getLog(BaggageTextMapPropagator.class);
    private final List<String> remoteFields;
    private final BaggageManager baggageManager;

    public BaggageTextMapPropagator(List<String> remoteFields, BaggageManager baggageManager) {
        this.remoteFields = remoteFields;
        this.baggageManager = baggageManager;
    }

    public List<String> fields() {
        return this.remoteFields;
    }

    public <C> void inject(Context context, C c, TextMapSetter<C> setter) {
        List<Map.Entry<String, String>> baggageEntries = this.applicableBaggageEntries(c);
        baggageEntries.forEach(e -> setter.set(c, (String)e.getKey(), (String)e.getValue()));
    }

    private <C> List<Map.Entry<String, String>> applicableBaggageEntries(C c) {
        Map allBaggage = this.baggageManager.getAllBaggage();
        List lowerCaseKeys = this.remoteFields.stream().map(String::toLowerCase).collect(Collectors.toList());
        return allBaggage.entrySet().stream().filter(e -> lowerCaseKeys.contains(((String)e.getKey()).toLowerCase())).collect(Collectors.toList());
    }

    public <C> Context extract(Context context, C c, TextMapGetter<C> getter) {
        Map<String, String> baggageEntries = this.remoteFields.stream().map(s -> new AbstractMap.SimpleEntry<String, String>((String)s, getter.get(c, s))).filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
        BaggageBuilder builder = Baggage.current().toBuilder();
        baggageEntries.forEach((key, value) -> builder.put(key, value, BaggageEntryMetadata.create((String)PROPAGATION_UNLIMITED)));
        Baggage.fromContext((Context)context).forEach((s, baggageEntry) -> builder.put(s, baggageEntry.getValue(), baggageEntry.getMetadata()));
        Baggage baggage = builder.build();
        Context withBaggage = context.with((ImplicitContextKeyed)baggage);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will propagate new baggage context for entries " + baggageEntries));
        }
        return withBaggage;
    }
}

