/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.reactor.SpanSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Operators;

public abstract class ReactorSleuth {
    private static final Predicate<Scannable> POINTCUT_FILTER = s -> !(s instanceof Fuseable.ScalarCallable) && s.isScanAvailable();

    public static <T> Function<? super Publisher<T>, ? extends Publisher<T>> spanOperator(Tracer tracer) {
        return Operators.lift(POINTCUT_FILTER, (scannable, sub) -> {
            if (scannable instanceof Fuseable && sub instanceof Fuseable.QueueSubscription) {
                return sub;
            }
            return new SpanSubscriber(sub, sub.currentContext(), tracer, scannable.name());
        });
    }

    private ReactorSleuth() {
    }
}

