/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.async.TraceableScheduledExecutorService;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.reactor.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Mono.class})
@AutoConfigureAfter(value={TraceAutoConfiguration.class})
public class TraceReactorAutoConfiguration {

    @Configuration
    @ConditionalOnBean(value={Tracer.class})
    static class TraceReactorConfiguration {
        private static final String SLEUTH_TRACE_REACTOR_KEY = TraceReactorConfiguration.class.getName();
        @Autowired
        Tracer tracer;
        @Autowired
        TraceKeys traceKeys;
        @Autowired
        SpanNamer spanNamer;

        TraceReactorConfiguration() {
        }

        @PostConstruct
        public void setupHooks() {
            Hooks.onLastOperator((String)SLEUTH_TRACE_REACTOR_KEY, ReactorSleuth.spanOperator(this.tracer));
            Schedulers.setFactory((Schedulers.Factory)new Schedulers.Factory(){

                public ScheduledExecutorService decorateExecutorService(String schedulerType, Supplier<? extends ScheduledExecutorService> actual) {
                    return new TraceableScheduledExecutorService(actual.get(), tracer, traceKeys, spanNamer);
                }
            });
        }

        @PreDestroy
        public void cleanupHooks() {
            Hooks.resetOnLastOperator();
            Schedulers.resetFactory();
        }
    }
}

