/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave;

import brave.Tracing;
import brave.handler.SpanHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.StrictScopeDecorator;
import brave.propagation.ThreadLocalCurrentTraceContext;
import brave.sampler.Sampler;
import java.io.Closeable;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.brave.BraveTestSpanHandler;
import org.springframework.cloud.sleuth.brave.BraveTestTracingAssertions;
import org.springframework.cloud.sleuth.brave.bridge.BraveAccessor;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.http.HttpRequestParser;
import org.springframework.cloud.sleuth.http.HttpServerHandler;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.cloud.sleuth.test.TestTracingAssertions;
import org.springframework.cloud.sleuth.test.TestTracingAware;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;
import org.springframework.cloud.sleuth.test.TracerAware;

public class BraveTestTracing
implements TracerAware,
TestTracingAware,
TestTracingAwareSupplier,
Closeable {
    brave.test.TestSpanHandler spans = new brave.test.TestSpanHandler();
    Sampler sampler = Sampler.ALWAYS_SAMPLE;
    ThreadLocalCurrentTraceContext context = ThreadLocalCurrentTraceContext.newBuilder().addScopeDecorator((CurrentTraceContext.ScopeDecorator)StrictScopeDecorator.create()).build();
    Tracing.Builder builder = this.tracingBuilder();
    Tracing tracing = this.builder.build();
    brave.Tracer tracer = this.tracing.tracer();
    HttpTracing httpTracing = this.httpTracingBuilder().build();

    public Tracing.Builder tracingBuilder() {
        Tracing.Builder builder;
        this.builder = builder = Tracing.newBuilder().currentTraceContext((brave.propagation.CurrentTraceContext)this.context).sampler(this.sampler).addSpanHandler(this.spanHandler());
        return builder;
    }

    public BraveTestTracing tracingBuilder(Tracing.Builder builder) {
        this.builder = builder;
        return this;
    }

    public HttpTracing.Builder httpTracingBuilder() {
        return HttpTracing.newBuilder((Tracing)this.tracing);
    }

    @Override
    public Tracer tracer() {
        return BraveAccessor.tracer(this.tracer);
    }

    @Override
    public TracerAware sampler(TracerAware.TraceSampler sampler) {
        this.sampler = sampler == TracerAware.TraceSampler.ON ? Sampler.ALWAYS_SAMPLE : Sampler.NEVER_SAMPLE;
        this.builder = this.tracingBuilder();
        this.reset();
        return this;
    }

    public void reset() {
        this.tracing = this.builder.build();
        this.tracer = this.tracing.tracer();
        this.httpTracing = this.httpTracingBuilder().build();
    }

    SpanHandler spanHandler() {
        return this.spans;
    }

    @Override
    public CurrentTraceContext currentTraceContext() {
        return BraveAccessor.currentTraceContext((brave.propagation.CurrentTraceContext)this.context);
    }

    @Override
    public Propagator propagator() {
        return BraveAccessor.propagator(this.tracing);
    }

    @Override
    public HttpServerHandler httpServerHandler() {
        return BraveAccessor.httpServerHandler((brave.http.HttpServerHandler<HttpServerRequest, HttpServerResponse>)brave.http.HttpServerHandler.create((HttpTracing)this.httpTracing));
    }

    @Override
    public TracerAware clientRequestParser(HttpRequestParser httpRequestParser) {
        this.reset();
        this.httpTracing = this.httpTracing.toBuilder().clientRequestParser(BraveAccessor.httpRequestParser(httpRequestParser)).build();
        return this;
    }

    @Override
    public HttpClientHandler httpClientHandler() {
        return BraveAccessor.httpClientHandler((brave.http.HttpClientHandler<HttpClientRequest, HttpClientResponse>)brave.http.HttpClientHandler.create((HttpTracing)this.httpTracing));
    }

    @Override
    public TracerAware tracing() {
        return this;
    }

    @Override
    public TestSpanHandler handler() {
        return new BraveTestSpanHandler(this.spans);
    }

    @Override
    public TestTracingAssertions assertions() {
        return new BraveTestTracingAssertions();
    }

    @Override
    public TestTracingAware tracerTest() {
        return this;
    }

    @Override
    public void close() {
        this.spans.clear();
        this.context.clear();
        this.handler().clear();
        this.sampler = Sampler.ALWAYS_SAMPLE;
    }
}

