/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.integration.notsampled;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.ServiceInstanceListSuppliers;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@ContextConfiguration(classes={TestConfiguration.class})
@TestPropertySource(properties={"spring.sleuth.web.servlet.enabled=false", "spring.application.name=fooservice", "spring.sleuth.web.client.skip-pattern=/skip.*"})
@DirtiesContext
public abstract class WebClientNotSampledTests {
    @Autowired
    TestFeignInterface testFeignInterface;
    @Autowired
    @LoadBalanced
    RestTemplate template;
    @Autowired
    TestSpanHandler spans;
    @Autowired
    Tracer tracer;
    @LocalServerPort
    int port;
    @Autowired
    FooController fooController;

    @AfterEach
    @BeforeEach
    public void close() {
        this.spans.clear();
        this.fooController.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"parametersForShouldPropagateNotSamplingHeader"})
    public void shouldPropagateNotSamplingHeader(ResponseEntityProvider provider) {
        Span span = this.tracer.nextSpan().name("foo").start();
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span);){
            ResponseEntity response = provider.get(this);
            this.assertB3SingleNotSampled((ResponseEntity<Map<String, String>>)response);
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Iterable)this.spans).isEmpty();
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    public void assertB3SingleNotSampled(ResponseEntity<Map<String, String>> response) {
        throw new UnsupportedOperationException("Implement this assertion");
    }

    static Stream parametersForShouldPropagateNotSamplingHeader() throws Exception {
        return Stream.of(tests -> tests.testFeignInterface.headers(), tests -> tests.template.getForEntity("http://fooservice/", Map.class, new Object[0]));
    }

    @Configuration(proxyBeanMethods=false)
    public static class SimpleLoadBalancerClientConfiguration {
        @Value(value="${local.server.port}")
        private int port = 0;

        @Bean
        public ServiceInstanceListSupplier serviceInstanceListSupplier() {
            return ServiceInstanceListSuppliers.from((String)"fooservice", (ServiceInstance[])new ServiceInstance[]{new DefaultServiceInstance("fooservice-1", "fooservice", "localhost", this.port, false)});
        }
    }

    @RestController
    public static class FooController {
        Span span;

        @RequestMapping(value={"/"})
        public Map<String, String> home(@RequestHeader HttpHeaders headers) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : headers.keySet()) {
                map.put(key, headers.getFirst(key));
            }
            return map;
        }

        public Span getSpan() {
            return this.span;
        }

        public void clear() {
            this.span = null;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration(exclude={JmxAutoConfiguration.class})
    @EnableFeignClients
    @LoadBalancerClient(value="fooservice", configuration={SimpleLoadBalancerClientConfiguration.class})
    public static class TestConfiguration {
        @Bean
        FooController fooController() {
            return new FooController();
        }

        @LoadBalanced
        @Bean
        public RestTemplate restTemplate() {
            return new RestTemplate();
        }
    }

    @FunctionalInterface
    static interface ResponseEntityProvider {
        public ResponseEntity get(WebClientNotSampledTests var1);
    }

    @FeignClient(value="fooservice")
    public static interface TestFeignInterface {
        @RequestMapping(method={RequestMethod.GET}, value={"/"})
        public ResponseEntity<Map<String, String>> headers();
    }
}

