/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.baggage.multiple;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.ListAssert;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.context.ServletWebServerInitializedEvent;
import org.springframework.cloud.sleuth.BaggageInScope;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.baggage.multiple.DemoApplication;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@ContextConfiguration(classes={TestConfig.class})
@TestPropertySource(properties={"spring.sleuth.baggage.remote-fields=x-vcap-request-id,country-code,Foo-Id", "spring.sleuth.baggage.local-fields=bp", "spring.sleuth.integration.enabled=true"})
public abstract class MultipleHopsIntegrationTests {
    protected static final String REQUEST_ID = "x-vcap-request-id";
    protected static final String BUSINESS_PROCESS = "bp";
    protected static final String COUNTRY_CODE = "country-code";
    protected static final String CASE_INSENSITIVE_ID = "Foo-Id";
    protected static final String NOT_PROPAGATED_HEADER = "baz-id";
    @Autowired
    Tracer tracer;
    @Autowired
    protected TestSpanHandler spans;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    TestConfig testConfig;
    @Autowired
    protected DemoApplication application;

    @BeforeEach
    public void setup() {
        this.spans.clear();
    }

    @Test
    public void should_prepare_spans_for_export() {
        this.restTemplate.getForObject("http://localhost:" + this.testConfig.port + "/greeting", String.class, new Object[0]);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((Iterable)this.spans).hasSize(14));
        this.assertSpanNames();
        BDDAssertions.then((Iterable)this.spans).extracting(FinishedSpan::getKind).containsAll(Arrays.asList(Span.Kind.CONSUMER, Span.Kind.PRODUCER, Span.Kind.SERVER));
        ((ListAssert)BDDAssertions.then(this.spans.reportedSpans().stream().map(span -> (String)span.getTags().get("channel")).filter(Objects::nonNull).distinct().collect(Collectors.toList())).hasSize(3)).containsAll(Arrays.asList("words", "counts", "greetings"));
    }

    protected void assertSpanNames() {
        throw new UnsupportedOperationException("Implement this assertion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_propagate_the_baggage() {
        Span initialSpan = this.tracer.nextSpan().name("span").start();
        try (Tracer.SpanInScope ws = this.tracer.withSpan(initialSpan);){
            BaggageInScope businessProcess = this.tracer.createBaggage(BUSINESS_PROCESS).set("ALM");
            BaggageInScope countryCode = this.tracer.createBaggage(COUNTRY_CODE).set("FO");
            try {
                initialSpan.tag(BUSINESS_PROCESS, "ALM");
                HttpHeaders headers = new HttpHeaders();
                headers.put(REQUEST_ID, Collections.singletonList("f4308d05-2228-4468-80f6-92a8377ba193"));
                headers.put(CASE_INSENSITIVE_ID, Collections.singletonList("123"));
                headers.put(NOT_PROPAGATED_HEADER, Collections.singletonList("456"));
                RequestEntity requestEntity = new RequestEntity((MultiValueMap)headers, HttpMethod.GET, URI.create("http://localhost:" + this.testConfig.port + "/greeting"));
                this.restTemplate.exchange(requestEntity, String.class);
            }
            finally {
                countryCode.close();
                businessProcess.close();
            }
        }
        finally {
            initialSpan.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((Iterable)this.spans).isNotEmpty());
        List withBagTags = this.spans.reportedSpans().stream().filter(s -> s.getTags().containsKey(BUSINESS_PROCESS)).collect(Collectors.toList());
        ((ListAssert)BDDAssertions.then(withBagTags).as("only initialSpan was bag tagged", new Object[0])).hasSize(1);
        Assertions.assertThat((Map)((FinishedSpan)withBagTags.get(0)).getTags()).containsEntry((Object)BUSINESS_PROCESS, (Object)"ALM");
        Set traceIds = this.application.allSpans().stream().map(s -> s.context().traceId()).collect(Collectors.toSet());
        BDDAssertions.then(traceIds).hasSize(1);
        ((AbstractStringAssert)BDDAssertions.then((String)((String)traceIds.iterator().next())).as("All have same trace ID", new Object[0])).isEqualTo(initialSpan.context().traceId());
        this.assertBaggage(initialSpan);
    }

    protected void assertBaggage(Span initialSpan) {
        throw new UnsupportedOperationException("Implement this assertion");
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={DemoApplication.class})
    public static class TestConfig
    implements ApplicationListener<ServletWebServerInitializedEvent> {
        int port;

        public void onApplicationEvent(ServletWebServerInitializedEvent event) {
            this.port = event.getSource().getPort();
        }

        @Bean
        RestTemplate restTemplate() {
            return new RestTemplate();
        }
    }
}

