/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.kafka;

import java.util.HashMap;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;

public final class KafkaTestUtils {
    private KafkaTestUtils() {
    }

    public static KafkaProducer<String, String> buildTestKafkaProducer(String bootstrapServers) {
        HashMap<String, Object> producerProperties = new HashMap<String, Object>();
        producerProperties.put("bootstrap.servers", bootstrapServers);
        producerProperties.put("key.serializer", StringSerializer.class);
        producerProperties.put("value.serializer", StringSerializer.class);
        return new KafkaProducer(producerProperties);
    }

    public static KafkaConsumer<String, String> buildTestKafkaConsumer(String bootstrapServers) {
        HashMap<String, Object> consumerProperties = new HashMap<String, Object>();
        consumerProperties.put("bootstrap.servers", bootstrapServers);
        consumerProperties.put("group.id", "test-consumer-group");
        consumerProperties.put("key.deserializer", StringDeserializer.class);
        consumerProperties.put("value.deserializer", StringDeserializer.class);
        consumerProperties.put("auto.offset.reset", "earliest");
        return new KafkaConsumer(consumerProperties);
    }
}

