/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import io.netty.bootstrap.Bootstrap;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.instrument.web.client.HttpClientBeanPostProcessor;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scheduler.Schedulers;
import reactor.netty.Connection;

@ExtendWith(value={MockitoExtension.class})
public abstract class HttpClientBeanPostProcessorTest {
    @Mock
    Connection connection;
    @Mock
    Bootstrap bootstrap;
    TraceContext traceContext = this.traceContext();

    public abstract TraceContext traceContext();

    @BeforeEach
    public void setup() {
        Hooks.resetOnEachOperator();
        Hooks.resetOnLastOperator();
        Schedulers.resetOnScheduleHooks();
    }

    @Test
    void mapConnect_should_setup_reactor_context_currentTraceContext() {
        HttpClientBeanPostProcessor.TracingMapConnect tracingMapConnect = new HttpClientBeanPostProcessor.TracingMapConnect(() -> this.traceContext);
        final AtomicBoolean assertionPassed = new AtomicBoolean();
        Mono original = Mono.just((Object)this.connection).handle((BiConsumer)new BiConsumer<Connection, SynchronousSink<Connection>>(){

            @Override
            public void accept(Connection t, SynchronousSink<Connection> ctx) {
                try {
                    Assertions.assertThat((Object)ctx.currentContext().get(TraceContext.class)).isSameAs((Object)HttpClientBeanPostProcessorTest.this.traceContext);
                    Assertions.assertThat((Object)ctx.currentContext().get((Object)"sleuth.pending-span")).isNotNull();
                    assertionPassed.set(true);
                }
                catch (AssertionError assertionError) {
                    // empty catch block
                }
            }
        });
        tracingMapConnect.apply(original).log().subscribe();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilTrue(assertionPassed);
    }

    @Test
    void mapConnect_should_setup_reactor_context_no_currentTraceContext() {
        HttpClientBeanPostProcessor.TracingMapConnect tracingMapConnect = new HttpClientBeanPostProcessor.TracingMapConnect(() -> null);
        final AtomicBoolean assertionPassed = new AtomicBoolean();
        Mono original = Mono.just((Object)this.connection).handle((BiConsumer)new BiConsumer<Connection, SynchronousSink<Connection>>(){

            @Override
            public void accept(Connection t, SynchronousSink<Connection> ctx) {
                try {
                    Assertions.assertThat((Optional)ctx.currentContext().getOrEmpty(TraceContext.class)).isEmpty();
                    Assertions.assertThat((Object)ctx.currentContext().get((Object)"sleuth.pending-span")).isNotNull();
                    assertionPassed.set(true);
                }
                catch (AssertionError assertionError) {
                    // empty catch block
                }
            }
        });
        tracingMapConnect.apply(original).log().subscribe();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilTrue(assertionPassed);
    }
}

